/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.gameinput;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.bonus.Bonus;
import com.agateau.pixelwheels.debug.DebugStringMap;
import com.agateau.pixelwheels.gameinput.DigitalSteering;
import com.agateau.pixelwheels.gameinput.GameInput;
import com.agateau.pixelwheels.gameinput.GameInputHandler;
import com.agateau.pixelwheels.racescreen.Hud;
import com.agateau.ui.InputMapper;
import com.agateau.ui.VirtualKey;
import com.badlogic.gdx.Preferences;

public abstract class InputMapperInputHandler
implements GameInputHandler {
    private final InputMapper mInputMapper;
    private final GameInput mInput = new GameInput();
    private final DigitalSteering mSteer = new DigitalSteering();

    InputMapperInputHandler(InputMapper inputMapper) {
        this.mInputMapper = inputMapper;
    }

    @Override
    public GameInput getGameInput() {
        this.mInput.braking = this.mInputMapper.isKeyPressed(VirtualKey.DOWN) || this.mInputMapper.isKeyPressed(VirtualKey.BACK);
        this.mInput.accelerating = !this.mInput.braking;
        this.mInput.leftPressed = this.mInputMapper.isKeyPressed(VirtualKey.LEFT);
        this.mInput.rightPressed = this.mInputMapper.isKeyPressed(VirtualKey.RIGHT);
        this.mInput.direction = this.mSteer.steer(this.mInput.leftPressed, this.mInput.rightPressed);
        DebugStringMap.putPercent("direction", Math.abs(this.mInput.direction));
        this.mInput.triggeringBonus = this.mInputMapper.isKeyPressed(VirtualKey.TRIGGER);
        return this.mInput;
    }

    @Override
    public void loadConfig(Preferences preferences, String prefix, int playerIdx) {
        this.mInputMapper.loadConfig(preferences, prefix, playerIdx);
    }

    @Override
    public void saveConfig(Preferences preferences, String prefix) {
        this.mInputMapper.saveConfig(preferences, prefix);
    }

    @Override
    public void createHudButtons(Assets assets, Hud hud) {
    }

    @Override
    public void setBonus(Bonus bonus) {
    }

    @Override
    public boolean isAvailable() {
        return this.mInputMapper.isAvailable();
    }

    public InputMapper getInputMapper() {
        return this.mInputMapper;
    }
}

