/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.map;

import com.agateau.pixelwheels.map.Material;
import com.agateau.utils.log.NLog;
import com.badlogic.gdx.maps.MapObject;
import com.badlogic.gdx.maps.MapProperties;
import com.badlogic.gdx.maps.tiled.TiledMapTile;

public class MapUtils {
    public static float getFloatProperty(MapProperties properties, String key, float defaultValue) {
        Object value = properties.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Float.parseFloat(value.toString());
    }

    public static int getIntProperty(MapProperties properties, String key, int defaultValue) {
        Object value = properties.get(key);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value.toString());
    }

    public static boolean getBooleanProperty(MapProperties properties, String key, boolean defaultValue) {
        Object value = properties.get(key);
        if (value == null) {
            return defaultValue;
        }
        String v = value.toString();
        if (v.equals("true")) {
            return true;
        }
        if (v.equals("false")) {
            return false;
        }
        NLog.e("invalid boolean value: %s", v);
        return defaultValue;
    }

    public static Material getTileMaterial(TiledMapTile tile) {
        if (tile == null) {
            return Material.ROAD;
        }
        Object value = tile.getProperties().get("material");
        if (value == null) {
            return Material.ROAD;
        }
        String materialName = value.toString();
        if (materialName.isEmpty()) {
            return Material.ROAD;
        }
        return Material.valueOf(materialName);
    }

    public static String getObstacleId(MapObject object) {
        Object value = object.getProperties().get("type");
        return value == null ? null : value.toString();
    }

    public static void setObstacleId(MapObject object, String id) {
        object.getProperties().put("type", id);
    }

    public static boolean isBorderObstacle(MapObject object) {
        return MapUtils.getObstacleId(object) == null;
    }

    public static float getObjectRotation(MapObject object) {
        return -object.getProperties().get("rotation", Float.valueOf(0.0f), Float.class).floatValue();
    }

    public static void setObjectRotation(MapObject object, float rotation) {
        object.getProperties().put("rotation", Float.valueOf(-rotation));
    }
}

