/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.map;

import com.agateau.pixelwheels.map.Material;
import com.agateau.pixelwheels.map.Track;
import com.badlogic.gdx.math.Vector2;

public class MaterialChecker {
    private final Vector2 mTmpVector = new Vector2();
    private final Track mTrack;

    public MaterialChecker(Track track) {
        this.mTrack = track;
    }

    public Material getSlowestMaterialAhead(Vector2 position, Vector2 target) {
        Material slowest = Material.ROAD;
        float len = this.mTmpVector.set(target).sub(position).len();
        int steps = (int)Math.ceil(len / this.mTrack.getTileWidth());
        for (int progress = 1; progress <= steps; ++progress) {
            this.mTmpVector.set(position).lerp(target, (float)progress / (float)steps);
            Material material = this.mTrack.getMaterialAt(this.mTmpVector);
            if (!(material.getSpeed() < slowest.getSpeed())) continue;
            slowest = material;
        }
        return slowest;
    }
}

