/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.obstacles;

import com.agateau.pixelwheels.TextureRegionProvider;
import com.agateau.pixelwheels.obstacles.ObstacleDef;
import com.agateau.utils.FileUtils;
import com.agateau.utils.log.NLog;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.XmlReader;

public class ObstacleIO {
    public static Array<ObstacleDef> getAll(TextureRegionProvider provider) {
        String fileName = "obstacles.xml";
        FileHandle handle = FileUtils.assets(fileName);
        if (!handle.exists()) {
            throw new RuntimeException("No such file " + fileName);
        }
        XmlReader.Element root = FileUtils.parseXml(handle);
        if (root == null) {
            throw new RuntimeException("Failed to parse " + fileName);
        }
        try {
            return ObstacleIO.getAll(provider, root);
        }
        catch (Exception e) {
            NLog.e("Error loading obstacles from %s: %s", fileName, e);
            e.printStackTrace();
            throw new RuntimeException("Error loading vehicle from " + fileName);
        }
    }

    private static Array<ObstacleDef> getAll(TextureRegionProvider provider, XmlReader.Element root) {
        Array<ObstacleDef> array = new Array<ObstacleDef>();
        for (XmlReader.Element child : root.getChildrenByName("obstacle")) {
            array.add(ObstacleIO.get(provider, child));
        }
        return array;
    }

    private static ObstacleDef get(TextureRegionProvider provider, XmlReader.Element child) {
        String id = child.getAttribute("id");
        ObstacleDef def = new ObstacleDef(id);
        def.density = child.getFloatAttribute("density");
        def.dynamic = child.getBooleanAttribute("dynamic", true);
        String shapeName = child.getAttribute("shape");
        if ("circle".equals(shapeName)) {
            def.createCircleShape(provider);
        } else if ("rectangle".equals(shapeName)) {
            def.createRectangleShape(provider);
        } else {
            throw new RuntimeException("Unknown shape " + shapeName);
        }
        return def;
    }
}

