/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.obstacles.tiled;

import com.agateau.pixelwheels.GameWorld;
import com.agateau.pixelwheels.obstacles.tiled.TiledObstacleCreator;
import com.agateau.pixelwheels.obstacles.tiled.TiledObstacleDef;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.CircleShape;
import com.badlogic.gdx.physics.box2d.World;
import com.google.gson.JsonObject;

class CircleDef
implements TiledObstacleDef {
    private final float mRadius;
    private final Vector2 mOrigin = new Vector2();
    private final BodyDef mBodyDef = new BodyDef();

    public CircleDef(JsonObject object) {
        this.mBodyDef.type = BodyDef.BodyType.StaticBody;
        this.mBodyDef.bullet = false;
        this.mRadius = object.get("radius").getAsFloat();
        this.mOrigin.x = object.get("x").getAsFloat();
        this.mOrigin.y = object.get("y").getAsFloat();
    }

    @Override
    public void create(GameWorld world, int col, int row, int tileSize, TiledMapTileLayer.Cell cell) {
        World box2DWorld = world.getBox2DWorld();
        float k = (float)tileSize * 0.05f;
        this.mBodyDef.position.set(col, row).add(this.mOrigin).scl(k);
        Body body = box2DWorld.createBody(this.mBodyDef);
        CircleShape shape = new CircleShape();
        shape.setRadius(this.mRadius * k);
        body.createFixture(shape, 1.0f);
        shape.dispose();
        TiledObstacleCreator.setWallCollisionInfo(body);
    }
}

