/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.obstacles.tiled;

import com.agateau.pixelwheels.GameWorld;
import com.agateau.pixelwheels.obstacles.tiled.TiledObstacleCreator;
import com.agateau.pixelwheels.obstacles.tiled.TiledObstacleDef;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.physics.box2d.World;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

class RectangleDef
implements TiledObstacleDef {
    private static final Polygon sPolygon = new Polygon(new float[8]);
    private static final BodyDef sBodyDef = new BodyDef();
    private final Rectangle mRectangle = new Rectangle();
    private final float mAngle;

    public RectangleDef(JsonObject object) {
        this.mRectangle.x = object.get("x").getAsFloat() - 0.5f;
        this.mRectangle.y = object.get("y").getAsFloat() - 0.5f;
        this.mRectangle.width = object.get("width").getAsFloat();
        this.mRectangle.height = object.get("height").getAsFloat();
        JsonElement angleElement = object.get("angle");
        this.mAngle = angleElement == null ? 0.0f : angleElement.getAsFloat();
    }

    @Override
    public void create(GameWorld world, int col, int row, int tileSize, TiledMapTileLayer.Cell cell) {
        RectangleDef.createRectangle(world, col, row, tileSize, this.mRectangle, this.mAngle, cell.getRotation(), cell.getFlipHorizontally(), cell.getFlipVertically());
    }

    static void createRectangle(GameWorld world, int col, int row, int tileSize, Rectangle rectangle) {
        RectangleDef.createRectangle(world, col, row, tileSize, rectangle, 0.0f, 0, false, false);
    }

    static void createRectangle(GameWorld world, int col, int row, int tileSize, Rectangle rectangle, float angle, int cellRotation, boolean hflip, boolean vflip) {
        World box2DWorld = world.getBox2DWorld();
        float k = (float)tileSize * 0.05f;
        float[] vertices = sPolygon.getVertices();
        vertices[0] = rectangle.x;
        vertices[1] = rectangle.y + rectangle.height;
        vertices[2] = rectangle.x;
        vertices[3] = rectangle.y;
        vertices[4] = rectangle.x + rectangle.width;
        vertices[5] = rectangle.y;
        vertices[6] = rectangle.x + rectangle.width;
        vertices[7] = rectangle.y + rectangle.height;
        float hk = hflip ? -k : k;
        float vk = vflip ? -k : k;
        sPolygon.setScale(hk, vk);
        if (hflip) {
            angle = 180.0f - angle;
        }
        if (vflip) {
            angle = -angle;
        }
        sPolygon.setRotation((float)(cellRotation * 90) + angle);
        PolygonShape shape = new PolygonShape();
        shape.set(sPolygon.getTransformedVertices());
        RectangleDef.sBodyDef.position.set(col, row).add(0.5f, 0.5f).scl(k);
        Body body = box2DWorld.createBody(sBodyDef);
        body.createFixture(shape, 1.0f);
        shape.dispose();
        TiledObstacleCreator.setWallCollisionInfo(body);
    }

    static {
        RectangleDef.sBodyDef.type = BodyDef.BodyType.StaticBody;
        RectangleDef.sBodyDef.bullet = false;
    }
}

