/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.racer;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.GamePlay;
import com.agateau.pixelwheels.GameWorld;
import com.agateau.pixelwheels.ZLevel;
import com.agateau.pixelwheels.bonus.Bonus;
import com.agateau.pixelwheels.bonus.BonusPool;
import com.agateau.pixelwheels.debug.Debug;
import com.agateau.pixelwheels.gameobject.AudioClipper;
import com.agateau.pixelwheels.gameobject.CellFrameBufferManager;
import com.agateau.pixelwheels.gameobject.CellFrameBufferUser;
import com.agateau.pixelwheels.gameobject.GameObjectAdapter;
import com.agateau.pixelwheels.gamesetup.GameInfo;
import com.agateau.pixelwheels.racer.AudioComponent;
import com.agateau.pixelwheels.racer.BonusSpotHitComponent;
import com.agateau.pixelwheels.racer.DisruptedComponent;
import com.agateau.pixelwheels.racer.HoleHandlerComponent;
import com.agateau.pixelwheels.racer.LapPositionComponent;
import com.agateau.pixelwheels.racer.Pilot;
import com.agateau.pixelwheels.racer.PlayerPilot;
import com.agateau.pixelwheels.racer.Probe;
import com.agateau.pixelwheels.racer.Vehicle;
import com.agateau.pixelwheels.racer.VehicleRenderer;
import com.agateau.pixelwheels.racescreen.Collidable;
import com.agateau.pixelwheels.sound.AudioManager;
import com.agateau.pixelwheels.stats.GameStats;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.Contact;
import com.badlogic.gdx.physics.box2d.ContactImpulse;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.Manifold;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;

public class Racer
extends GameObjectAdapter
implements Collidable,
Disposable,
CellFrameBufferUser {
    private final GameWorld mGameWorld;
    private final Vehicle mVehicle;
    private final VehicleRenderer mVehicleRenderer;
    private final HoleHandlerComponent mHoleHandlerComponent;
    private final DisruptedComponent mDisruptedComponent;
    private final LapPositionComponent mLapPositionComponent;
    private final AudioComponent mAudioComponent;
    private final Array<Component> mComponents = new Array();
    private final Array<Collidable> mCollidableComponents = new Array();
    private final GameInfo.Entrant mEntrant;
    private Probe mSpeedReportProbe;
    private Pilot mPilot;
    private Bonus mBonus;
    private final RecordRanks mRecordRanks = new RecordRanks();
    private final Vector2 mTmp = new Vector2();

    @Override
    public void init(CellFrameBufferManager manager) {
        this.mVehicleRenderer.init(manager);
    }

    @Override
    public void drawToCell(Batch batch, Rectangle viewBounds) {
        float old = batch.getPackedColor();
        if (this.isDisrupted()) {
            float k = MathUtils.lerp(1.0f, 0.1f, this.mDisruptedComponent.getNormalizedDuration());
            k = Interpolation.pow2.apply(k);
            batch.setColor(k, k, k, 1.0f);
        }
        this.mVehicleRenderer.drawToCell(batch, viewBounds);
        batch.setPackedColor(old);
    }

    public boolean isDisrupted() {
        return this.mDisruptedComponent.isActive();
    }

    public Racer(Assets assets, AudioManager audioManager, GameWorld gameWorld, Vehicle vehicle, GameInfo.Entrant entrant) {
        this.mGameWorld = gameWorld;
        this.mLapPositionComponent = new LapPositionComponent(gameWorld.getTrack(), vehicle);
        this.mDisruptedComponent = new DisruptedComponent(assets, this);
        this.mVehicle = vehicle;
        this.mVehicle.setRacer(this);
        this.mVehicle.setCollisionInfo(2, 15);
        this.mEntrant = entrant;
        this.mVehicleRenderer = new VehicleRenderer(assets, this.mVehicle);
        this.mHoleHandlerComponent = new HoleHandlerComponent(assets, this.mGameWorld, this, this.mLapPositionComponent);
        PilotSupervisorComponent supervisorComponent = new PilotSupervisorComponent();
        this.mAudioComponent = new AudioComponent(assets.soundAtlas, audioManager, this);
        this.addComponent(this.mLapPositionComponent);
        this.addComponent(this.mVehicle);
        this.addComponent(this.mHoleHandlerComponent);
        this.addComponent(this.mDisruptedComponent);
        this.addComponent(supervisorComponent);
        this.addComponent(new BonusSpotHitComponent(this));
        this.addComponent(this.mAudioComponent);
        if (Debug.instance.createSpeedReport) {
            this.mSpeedReportProbe = new Probe("speed.jsonl");
            this.mVehicle.setSpeedReportProbe(this.mSpeedReportProbe);
            this.addComponent(this.mSpeedReportProbe);
        }
    }

    private void addComponent(Component component) {
        this.mComponents.add(component);
        if (component instanceof Collidable) {
            this.mCollidableComponents.add((Collidable)((Object)component));
        }
    }

    public RecordRanks getRecordRanks() {
        return this.mRecordRanks;
    }

    public GameInfo.Entrant getEntrant() {
        return this.mEntrant;
    }

    public Pilot getPilot() {
        return this.mPilot;
    }

    public void setPilot(Pilot pilot) {
        this.mPilot = pilot;
        if (this.mSpeedReportProbe != null && pilot instanceof PlayerPilot) {
            PlayerPilot playerPilot = (PlayerPilot)pilot;
            playerPilot.setSpeedReportProbe(this.mSpeedReportProbe);
        }
    }

    public Vehicle getVehicle() {
        return this.mVehicle;
    }

    public Bonus getBonus() {
        return this.mBonus;
    }

    public LapPositionComponent getLapPositionComponent() {
        return this.mLapPositionComponent;
    }

    public AudioComponent getAudioComponent() {
        return this.mAudioComponent;
    }

    public AudioManager getAudioManager() {
        return this.mAudioComponent.getAudioManager();
    }

    public void disrupt() {
        this.mDisruptedComponent.start();
        this.looseBonus();
    }

    public float getCameraAngle() {
        return this.mVehicle.getAngle();
    }

    @Override
    public void beginContact(Contact contact, Fixture otherFixture) {
        for (Collidable collidable : this.mCollidableComponents) {
            collidable.beginContact(contact, otherFixture);
        }
    }

    @Override
    public void endContact(Contact contact, Fixture otherFixture) {
        for (Collidable collidable : this.mCollidableComponents) {
            collidable.endContact(contact, otherFixture);
        }
    }

    @Override
    public void preSolve(Contact contact, Fixture otherFixture, Manifold oldManifold) {
        Object other = otherFixture.getBody().getUserData();
        if (other instanceof Racer) {
            contact.setEnabled(false);
            this.applySimplifiedRacerCollision((Racer)other);
        }
        for (Collidable collidable : this.mCollidableComponents) {
            collidable.preSolve(contact, otherFixture, oldManifold);
        }
    }

    private void applySimplifiedRacerCollision(Racer other) {
        Body body1 = this.getVehicle().getBody();
        Body body2 = other.getVehicle().getBody();
        this.mTmp.set(body2.getLinearVelocity()).sub(body1.getLinearVelocity());
        float deltaV = this.mTmp.len();
        float k = GamePlay.instance.simplifiedCollisionKFactor * MathUtils.clamp(deltaV / GamePlay.instance.simplifiedCollisionMaxDeltaV, 0.0f, 1.0f);
        this.mTmp.set(body2.getWorldCenter()).sub(body1.getWorldCenter()).nor().scl(k);
        body2.applyLinearImpulse(this.mTmp, body2.getWorldCenter(), true);
        this.mTmp.scl(-1.0f);
        body1.applyLinearImpulse(this.mTmp, body1.getWorldCenter(), true);
    }

    @Override
    public void postSolve(Contact contact, Fixture otherFixture, ContactImpulse impulse) {
        for (Collidable collidable : this.mCollidableComponents) {
            collidable.postSolve(contact, otherFixture, impulse);
        }
    }

    @Override
    public void dispose() {
        for (Component component : this.mComponents) {
            if (!(component instanceof Disposable)) continue;
            ((Disposable)((Object)component)).dispose();
        }
    }

    @Override
    public void act(float delta) {
        for (Component component : this.mComponents) {
            component.act(delta);
        }
        if (this.mBonus != null) {
            this.mBonus.act(delta);
        }
    }

    public void selectBonus() {
        BonusPool pool2;
        float normalizedRank = this.mGameWorld.getRacerNormalizedRank(this);
        Array<BonusPool> pools = this.mGameWorld.getBonusPools();
        float totalCount = 0.0f;
        for (BonusPool pool2 : pools) {
            totalCount += pool2.getCountForNormalizedRank(normalizedRank);
        }
        float pick = MathUtils.random(0.0f, totalCount);
        pool2 = null;
        for (int idx = 0; idx < pools.size && !((pick -= (pool2 = pools.get(idx)).getCountForNormalizedRank(normalizedRank)) < 0.0f); ++idx) {
        }
        if (pool2 == null) {
            pool2 = pools.get(pools.size - 1);
        }
        this.mBonus = (Bonus)pool2.obtain();
        this.mBonus.onPicked(this);
        this.getGameStats().recordEvent(GameStats.Event.PICKED_BONUS);
    }

    public void triggerBonus() {
        if (this.mBonus == null) {
            return;
        }
        this.mBonus.trigger();
    }

    public void resetBonus() {
        this.mBonus = null;
    }

    public void looseBonus() {
        if (this.mBonus != null) {
            this.mBonus.onOwnerHit();
        }
    }

    @Override
    public void draw(Batch batch, ZLevel zLevel, Rectangle viewBounds) {
        this.mVehicleRenderer.draw(batch, zLevel, viewBounds);
    }

    @Override
    public void audioRender(AudioClipper clipper) {
        this.mAudioComponent.render(clipper);
    }

    @Override
    public float getX() {
        return this.mVehicle.getX();
    }

    @Override
    public float getY() {
        return this.mVehicle.getY();
    }

    public VehicleRenderer getVehicleRenderer() {
        return this.mVehicleRenderer;
    }

    public void markRaceFinished() {
        this.mLapPositionComponent.markRaceFinished();
    }

    public String toString() {
        return "<racer pilot=" + this.mPilot + " vehicle=" + this.mVehicle + ">";
    }

    public GameStats getGameStats() {
        return this.mPilot.getGameStats();
    }

    public static int compareRaceDistances(Racer racer1, Racer racer2) {
        LapPositionComponent c1 = racer1.getLapPositionComponent();
        LapPositionComponent c2 = racer2.getLapPositionComponent();
        if (c1.hasFinishedRace() && c2.hasFinishedRace()) {
            return Float.compare(c2.getTotalTime(), c1.getTotalTime());
        }
        if (!c1.hasFinishedRace() && c2.hasFinishedRace()) {
            return -1;
        }
        if (c1.hasFinishedRace() && !c2.hasFinishedRace()) {
            return 1;
        }
        if (c1.getLapCount() < c2.getLapCount()) {
            return -1;
        }
        if (c1.getLapCount() > c2.getLapCount()) {
            return 1;
        }
        float d1 = c1.getLapDistance();
        float d2 = c2.getLapDistance();
        return Float.compare(d1, d2);
    }

    public static class RecordRanks {
        public int lapRecordRank = -1;
        public int totalRecordRank = -1;

        public boolean brokeRecord() {
            return this.lapRecordRank > -1 || this.totalRecordRank > -1;
        }
    }

    private class PilotSupervisorComponent
    implements Component {
        private PilotSupervisorComponent() {
        }

        @Override
        public void act(float delta) {
            if (Racer.this.mLapPositionComponent.hasFinishedRace() || Racer.this.mHoleHandlerComponent.getState() != HoleHandlerComponent.State.NORMAL) {
                Racer.this.mVehicle.setAccelerating(false);
                Racer.this.mVehicle.setBraking(false);
            } else if (Racer.this.mDisruptedComponent.isActive()) {
                Racer.this.mPilot.act(delta);
                Racer.this.mVehicle.setAccelerating(false);
            } else {
                Racer.this.mPilot.act(delta);
            }
        }
    }

    static interface Component {
        public void act(float var1);
    }
}

