/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.racer;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.racer.Wheel;
import com.agateau.utils.AgcMathUtils;
import com.agateau.utils.CircularArray;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;

public class SkidmarksRenderer {
    private static final float SKIDMARK_WIDTH = 0.35f;
    private static final float SKIDMARK_ALPHA_INC = 0.05f;
    private static final float SKIDMARK_ALPHA_MIN = 0.1f;
    private static final float SKIDMARK_ALPHA_MAX = 0.4f;
    private final Assets mAssets;
    private final float[] mVertices = new float[20];

    public SkidmarksRenderer(Assets assets) {
        this.mAssets = assets;
    }

    public void draw(Batch batch, CircularArray<Wheel.Skidmark> skidmarks, Rectangle viewBounds) {
        int idx = skidmarks.getBeginIndex();
        if (idx == skidmarks.getEndIndex()) {
            return;
        }
        Wheel.Skidmark mark2 = skidmarks.get(idx);
        idx = skidmarks.getNextIndex(idx);
        float alpha = 0.1f;
        while (idx != skidmarks.getEndIndex()) {
            block7: {
                Wheel.Skidmark mark1;
                block8: {
                    block6: {
                        mark1 = mark2;
                        mark2 = skidmarks.get(idx);
                        if (!mark1.isEndIndicator() && !mark2.isEndIndicator()) break block6;
                        alpha = 0.1f;
                        break block7;
                    }
                    if (mark1.isFinished() && mark2.isFinished()) break block7;
                    if (mark2.hasThickness()) break block8;
                    Vector2 pos1 = mark1.getPos();
                    Vector2 pos2 = mark2.getPos();
                    if (!viewBounds.contains(pos1) && !viewBounds.contains(pos2)) break block7;
                    Vector2 thickness = AgcMathUtils.computeWidthVector(pos1, pos2, 0.175f);
                    mark2.setThickness(thickness);
                    if (!mark1.hasThickness()) {
                        mark1.setThickness(thickness);
                    }
                }
                this.drawSkidmark(batch, mark1, mark2, alpha * mark1.getOpacity(), (alpha + 0.05f) * mark2.getOpacity());
                alpha = Math.min(0.4f, alpha + 0.05f);
            }
            idx = skidmarks.getNextIndex(idx);
        }
    }

    private void drawSkidmark(Batch batch, Wheel.Skidmark mark1, Wheel.Skidmark mark2, float alpha1, float alpha2) {
        TextureRegion region = this.mAssets.skidmark;
        float c = Color.toFloatBits(1.0f, 1.0f, 1.0f, alpha1);
        float c2 = Color.toFloatBits(1.0f, 1.0f, 1.0f, alpha2);
        float u = region.getU();
        float v = region.getV();
        float u2 = region.getU2();
        float v2 = region.getV2();
        Vector2 pos1 = mark1.getPos();
        Vector2 pos2 = mark2.getPos();
        float x0 = pos1.x + mark1.getThickness().x;
        float y0 = pos1.y + mark1.getThickness().y;
        float x1 = pos1.x - mark1.getThickness().x;
        float y1 = pos1.y - mark1.getThickness().y;
        float x2 = pos2.x - mark2.getThickness().x;
        float y2 = pos2.y - mark2.getThickness().y;
        float x3 = pos2.x + mark2.getThickness().x;
        float y3 = pos2.y + mark2.getThickness().y;
        this.initVertex(0, x0, y0, c, u, v);
        this.initVertex(1, x1, y1, c, u2, v);
        this.initVertex(2, x2, y2, c2, u2, v2);
        this.initVertex(3, x3, y3, c2, u, v2);
        batch.draw(region.getTexture(), this.mVertices, 0, this.mVertices.length);
    }

    private void initVertex(int index, float x, float y, float c, float u, float v) {
        int idx = index * 5;
        this.mVertices[idx++] = x;
        this.mVertices[idx++] = y;
        this.mVertices[idx++] = c;
        this.mVertices[idx++] = u;
        this.mVertices[idx] = v;
    }
}

