/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.racer;

import com.agateau.pixelwheels.GamePlay;
import com.agateau.pixelwheels.GameWorld;
import com.agateau.pixelwheels.TextureRegionProvider;
import com.agateau.pixelwheels.map.Material;
import com.agateau.pixelwheels.racer.Probe;
import com.agateau.pixelwheels.racer.Racer;
import com.agateau.pixelwheels.racer.Wheel;
import com.agateau.pixelwheels.stats.GameStats;
import com.agateau.pixelwheels.utils.Box2DUtils;
import com.agateau.pixelwheels.vehicledef.VehicleDef;
import com.agateau.utils.AgcMathUtils;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Shape2D;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.FixtureDef;
import com.badlogic.gdx.physics.box2d.MassData;
import com.badlogic.gdx.physics.box2d.joints.RevoluteJoint;
import com.badlogic.gdx.physics.box2d.joints.RevoluteJointDef;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ArrayMap;
import com.badlogic.gdx.utils.Disposable;

public class Vehicle
implements Racer.Component,
Disposable {
    private static final float ACCELERATION_DELTA = 1.0f;
    private static final float BRAKING_DELTA = 0.8f;
    private static final float MIN_ICE_DRIFT_ANGLE = 5.0f;
    private static final float MIN_ICE_DRIFT_SPEED = 4.0f;
    private static final float CENTER_OF_GRAVITY_SHIFT_PERCENT = 0.5f;
    private final String mId;
    private final Body mBody;
    private final GameWorld mGameWorld;
    private Racer mRacer;
    private final Animation<TextureRegion> mBodyAnimation;
    private final Array<WheelInfo> mWheels = new Array();
    private int mCollisionCategoryBits;
    private int mCollisionMaskBits;
    private boolean mAccelerating = false;
    private boolean mBraking = false;
    private float mZ = 0.0f;
    private float mDirection = 0.0f;
    private float mTurboTime = -1.0f;
    private boolean mStopped = false;
    private Material mMaterial = Material.ROAD;
    private float mSpeedLimiter = 1.0f;
    private boolean mFlying = false;
    private Probe mSpeedReportProbe = null;
    private final ArrayMap<Long, Float> mTurboCellMap = new ArrayMap(8);
    private final Array<Long> mTurboCellsUnderWheels = new Array();
    private final Vector2 mDirectionVector = new Vector2();

    public Vehicle(TextureRegionProvider textureRegionProvider, GameWorld gameWorld, float originX, float originY, VehicleDef vehicleDef, float angle) {
        this.mId = vehicleDef.id;
        this.mGameWorld = gameWorld;
        this.mBodyAnimation = vehicleDef.getAnimation(textureRegionProvider);
        this.mBodyAnimation.setPlayMode(Animation.PlayMode.LOOP);
        BodyDef bodyDef = new BodyDef();
        bodyDef.type = BodyDef.BodyType.DynamicBody;
        bodyDef.position.set(originX, originY);
        bodyDef.angle = angle * ((float)Math.PI / 180);
        this.mBody = this.mGameWorld.getBox2DWorld().createBody(bodyDef);
        for (Shape2D shape : vehicleDef.shapes) {
            FixtureDef fixtureDef = new FixtureDef();
            fixtureDef.shape = Box2DUtils.createBox2DShape(shape, 0.05f);
            fixtureDef.density = (float)GamePlay.instance.vehicleDensity / 10.0f;
            fixtureDef.friction = 0.2f;
            fixtureDef.restitution = (float)GamePlay.instance.vehicleRestitution / 10.0f;
            this.mBody.createFixture(fixtureDef);
            fixtureDef.shape.dispose();
        }
        this.moveCenterOfGravity(vehicleDef, textureRegionProvider);
    }

    private void moveCenterOfGravity(VehicleDef vehicleDef, TextureRegionProvider textureRegionProvider) {
        float halfVehicleLength = (float)vehicleDef.getImage(textureRegionProvider).getRegionHeight() / 2.0f;
        MassData massData = this.mBody.getMassData();
        massData.center.x += 0.5f * halfVehicleLength * 0.05f;
        this.mBody.setMassData(massData);
    }

    @Override
    public void dispose() {
        for (WheelInfo info : this.mWheels) {
            info.wheel.dispose();
        }
        this.mGameWorld.getBox2DWorld().destroyBody(this.mBody);
    }

    public WheelInfo addWheel(TextureRegion region, Animation<TextureRegion> splashAnimation, float density, float x, float y, float angle) {
        WheelInfo info = new WheelInfo();
        info.wheel = new Wheel(this.mGameWorld, this, region, splashAnimation, density, this.getX() + x, this.getY() + y, angle);
        this.mWheels.add(info);
        Body body = info.wheel.getBody();
        body.setUserData(this.mBody.getUserData());
        RevoluteJointDef jointDef = new RevoluteJointDef();
        jointDef.initialize(this.mBody, body, body.getPosition());
        jointDef.lowerAngle = 0.0f;
        jointDef.upperAngle = 0.0f;
        jointDef.enableLimit = true;
        info.joint = (RevoluteJoint)this.mGameWorld.getBox2DWorld().createJoint(jointDef);
        this.mTurboCellsUnderWheels.ensureCapacity(this.mWheels.size);
        return info;
    }

    public void setRacer(Racer racer) {
        this.mRacer = racer;
        this.mBody.setUserData(racer);
        for (WheelInfo info : this.mWheels) {
            info.wheel.getBody().setUserData(racer);
        }
    }

    public void setSpeedReportProbe(Probe probe) {
        this.mSpeedReportProbe = probe;
    }

    public void setCollisionInfo(int categoryBits, int maskBits) {
        this.mCollisionCategoryBits = categoryBits;
        this.mCollisionMaskBits = maskBits;
        this.applyCollisionInfo();
    }

    public Array<WheelInfo> getWheelInfos() {
        return this.mWheels;
    }

    public String getId() {
        return this.mId;
    }

    public Body getBody() {
        return this.mBody;
    }

    public TextureRegion getRegion(float time) {
        return this.mBodyAnimation.getKeyFrame(time);
    }

    public float getSpeed() {
        return this.mBody.getLinearVelocity().len();
    }

    public boolean isDrifting() {
        for (WheelInfo wheelInfo : this.mWheels) {
            if (!wheelInfo.wheel.isDrifting()) continue;
            return true;
        }
        return false;
    }

    public boolean isIceDrifting() {
        if (this.getSpeed() < 4.0f) {
            return false;
        }
        for (WheelInfo wheelInfo : this.mWheels) {
            if (wheelInfo.wheel.getMaterial() != Material.ICE) continue;
            float delta = AgcMathUtils.angleDelta(this.mBody.getLinearVelocity().angleDeg(), this.getAngle());
            return Math.abs(delta % 180.0f) > 5.0f;
        }
        return false;
    }

    boolean isOnWater() {
        for (WheelInfo wheelInfo : this.mWheels) {
            if (wheelInfo.wheel.getMaterial() != Material.WATER) continue;
            return true;
        }
        return false;
    }

    public void setSpeedLimiter(float speedLimiter) {
        this.mSpeedLimiter = speedLimiter;
    }

    public float getAngle() {
        return AgcMathUtils.normalizeAngle(this.mBody.getAngle() * 57.295776f);
    }

    public float getWidth() {
        return 0.05f * (float)this.getRegion(0.0f).getRegionWidth();
    }

    public float getHeight() {
        return 0.05f * (float)this.getRegion(0.0f).getRegionHeight();
    }

    public void setFlying(boolean flying) {
        if (flying == this.mFlying) {
            return;
        }
        if (flying) {
            Box2DUtils.setCollisionInfo(this.mBody, 0, 0);
            for (WheelInfo info : this.mWheels) {
                Box2DUtils.setCollisionInfo(info.wheel.getBody(), 0, 0);
            }
        } else {
            this.applyCollisionInfo();
        }
        this.mFlying = flying;
    }

    public boolean isFlying() {
        return this.mFlying;
    }

    public boolean isFalling() {
        return this.mZ < 0.0f;
    }

    public float getZ() {
        return this.mZ;
    }

    public void setZ(float z) {
        this.mZ = z;
    }

    public void setStopped(boolean stopped) {
        if (stopped) {
            this.mTurboTime = -1.0f;
        }
        this.mStopped = stopped;
    }

    @Override
    public void act(float dt) {
        if (!this.isFlying()) {
            if (this.mStopped) {
                this.actStopping(dt);
            } else {
                this.applyTurbo(dt);
                this.applyPilotCommands();
                this.applyGroundEffects(dt);
                this.updateMaterial();
            }
        }
        this.actWheels(dt);
    }

    private void actStopping(float dt) {
        Vector2 invVelocity = this.mBody.getLinearVelocity().scl(-0.1f);
        this.mBody.applyForce(invVelocity.scl(this.mBody.getMass()).scl(1.0f / dt), this.mBody.getWorldCenter(), true);
    }

    private void applyGroundEffects(float dt) {
        boolean turboOn;
        GamePlay GP = GamePlay.instance;
        float groundSpeed = 0.0f;
        this.mTurboCellsUnderWheels.clear();
        for (WheelInfo info : this.mWheels) {
            float wheelGroundSpeed = info.wheel.getGroundSpeed();
            groundSpeed += wheelGroundSpeed;
            long cellId = info.wheel.getCellId();
            boolean isTurboCell = wheelGroundSpeed > 1.0f;
            if (!isTurboCell || this.mRacer.isDisrupted()) continue;
            this.mTurboCellsUnderWheels.add(cellId);
            if (this.alreadyTriggeredTurboCell(cellId)) continue;
            this.triggerTurbo();
            this.addTriggeredTurboCell(cellId);
        }
        groundSpeed /= (float)this.mWheels.size;
        this.updateTriggeredTurboCells(dt);
        boolean bl = turboOn = this.mTurboTime > 0.0f;
        if (groundSpeed < 1.0f && !turboOn) {
            Box2DUtils.applyDrag(this.mBody, (1.0f - groundSpeed) * (float)GP.groundDragFactor);
        }
    }

    private void applyPilotCommands() {
        float speedDelta = 0.0f;
        if (this.mGameWorld.getState() == GameWorld.State.RUNNING) {
            if (this.mAccelerating) {
                speedDelta = 1.0f * this.mSpeedLimiter;
            }
            if (this.mBraking) {
                speedDelta -= 0.8f;
            }
        }
        float steerAngle = this.computeSteerAngle() * ((float)Math.PI / 180);
        for (WheelInfo info : this.mWheels) {
            float angle = info.steeringFactor * steerAngle;
            info.wheel.adjustSpeed(speedDelta);
            info.joint.setLimits(angle, angle);
        }
    }

    private void updateMaterial() {
        Material oldMaterial = this.mMaterial;
        this.mMaterial = this.mGameWorld.getTrack().getMaterialAt(this.mBody.getWorldCenter());
        if (!this.mMaterial.isRoad() && oldMaterial.isRoad()) {
            if (this.mMaterial == Material.SAND) {
                this.mRacer.getGameStats().recordEvent(GameStats.Event.ENTERING_SAND);
            } else {
                this.mRacer.getGameStats().recordEvent(GameStats.Event.LEAVING_ROAD);
            }
        }
    }

    private void actWheels(float dt) {
        for (WheelInfo info : this.mWheels) {
            info.wheel.act(dt);
        }
    }

    private Vector2 computeDirectionVector(float strength) {
        return this.mDirectionVector.set(strength, 0.0f).rotateRad(this.mBody.getAngle());
    }

    private void applyTurbo(float dt) {
        GamePlay GP = GamePlay.instance;
        if (this.mTurboTime == 0.0f) {
            this.mBody.applyLinearImpulse(this.computeDirectionVector((float)GP.turboStrength / 6.0f), this.mBody.getWorldCenter(), true);
        }
        if (this.mTurboTime >= 0.0f) {
            this.mTurboTime += dt;
            this.mBody.applyForce(this.computeDirectionVector(GP.turboStrength), this.mBody.getWorldCenter(), true);
            if (this.mTurboTime > GP.turboDuration) {
                this.mTurboTime = -1.0f;
            }
        }
    }

    private float computeSteerAngle() {
        int category;
        float steer;
        GamePlay GP = GamePlay.instance;
        if (MathUtils.isZero(this.mDirection)) {
            if (this.mSpeedReportProbe != null) {
                float speed = this.mBody.getLinearVelocity().len() * 3.6f;
                this.mSpeedReportProbe.addValue("x", Float.valueOf(this.getX()));
                this.mSpeedReportProbe.addValue("y", Float.valueOf(this.getY()));
                this.mSpeedReportProbe.addValue("steer", 0.0);
                this.mSpeedReportProbe.addValue("speed", Float.valueOf(speed));
                this.mSpeedReportProbe.addValue("category", -1);
                this.mSpeedReportProbe.addValue("direction", Float.valueOf(this.mDirection));
            }
            return 0.0f;
        }
        float speed = this.mBody.getLinearVelocity().len() * 3.6f;
        if (speed < (float)GP.lowSpeed) {
            steer = MathUtils.lerp(GP.stoppedMaxSteer, GP.lowSpeedMaxSteer, speed / (float)GP.lowSpeed);
            category = 0;
        } else if (speed < (float)GP.maxSpeed) {
            float factor = (speed - (float)GP.lowSpeed) / (float)(GP.maxSpeed - GP.lowSpeed);
            steer = MathUtils.lerp(GP.lowSpeedMaxSteer, GP.highSpeedMaxSteer, factor);
            category = 1;
        } else {
            steer = GP.highSpeedMaxSteer;
            category = 2;
        }
        if (this.mSpeedReportProbe != null) {
            this.mSpeedReportProbe.addValue("x", Float.valueOf(this.getX()));
            this.mSpeedReportProbe.addValue("y", Float.valueOf(this.getY()));
            this.mSpeedReportProbe.addValue("steer", Float.valueOf(steer));
            this.mSpeedReportProbe.addValue("speed", Float.valueOf(speed));
            this.mSpeedReportProbe.addValue("category", category);
            this.mSpeedReportProbe.addValue("direction", Float.valueOf(this.mDirection));
        }
        return this.mDirection * steer;
    }

    private boolean alreadyTriggeredTurboCell(long cellId) {
        return this.mTurboCellMap.containsKey(cellId);
    }

    private void addTriggeredTurboCell(long cellId) {
        this.mTurboCellMap.put(cellId, Float.valueOf(GamePlay.instance.turboDuration));
    }

    private void updateTriggeredTurboCells(float delta) {
        for (int idx = this.mTurboCellMap.size - 1; idx >= 0; --idx) {
            float duration = this.mTurboCellMap.getValueAt(idx).floatValue() - delta;
            if (duration <= 0.0f) {
                long cellId = this.mTurboCellMap.getKeyAt(idx);
                if (this.mTurboCellsUnderWheels.contains(cellId, false)) {
                    this.mTurboCellMap.setValue(idx, Float.valueOf(0.0f));
                    continue;
                }
                this.mTurboCellMap.removeIndex(idx);
                continue;
            }
            this.mTurboCellMap.setValue(idx, Float.valueOf(duration));
        }
    }

    public void setAccelerating(boolean value) {
        this.mAccelerating = value;
    }

    public void setBraking(boolean value) {
        this.mBraking = value;
    }

    public boolean isBraking() {
        return this.mBraking;
    }

    public void setDirection(float direction) {
        this.mDirection = direction;
    }

    public Vector2 getPosition() {
        return this.mBody.getPosition();
    }

    public float getX() {
        return this.mBody.getPosition().x;
    }

    public float getY() {
        return this.mBody.getPosition().y;
    }

    public float getTurboTime() {
        return this.mTurboTime;
    }

    public void triggerTurbo() {
        this.mRacer.getAudioComponent().triggerTurbo();
        this.mTurboTime = 0.0f;
    }

    private void applyCollisionInfo() {
        Box2DUtils.setCollisionInfo(this.mBody, this.mCollisionCategoryBits, this.mCollisionMaskBits);
        for (WheelInfo info : this.mWheels) {
            Box2DUtils.setCollisionInfo(info.wheel.getBody(), this.mCollisionCategoryBits, this.mCollisionMaskBits);
        }
    }

    public String toString() {
        return this.mId;
    }

    public static class WheelInfo {
        public Wheel wheel;
        public RevoluteJoint joint;
        public float steeringFactor;
    }
}

