/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.racescreen;

import com.agateau.pixelwheels.GameWorld;
import com.agateau.pixelwheels.sound.AudioManager;
import com.agateau.pixelwheels.sound.SoundAtlas;
import com.badlogic.gdx.math.MathUtils;

public class CountDown {
    private static final int START = 3;
    private static final float TICK_DURATION = 0.75f;
    private final GameWorld mGameWorld;
    private final AudioManager mAudioManager;
    private final SoundAtlas mSoundAtlas;
    private float mTime = 3.0f;
    private boolean mFirstCall = true;

    public CountDown(GameWorld gameWorld, AudioManager audioManager, SoundAtlas soundAtlas) {
        this.mGameWorld = gameWorld;
        this.mAudioManager = audioManager;
        this.mSoundAtlas = soundAtlas;
    }

    public int getValue() {
        return MathUtils.ceil(this.mTime);
    }

    public float getPercent() {
        return this.mTime - (float)MathUtils.floor(this.mTime);
    }

    public boolean isFinished() {
        return this.mTime < -1.0f;
    }

    public void act(float delta) {
        if (this.isFinished()) {
            return;
        }
        int oldValue = this.getValue();
        this.mTime -= delta / 0.75f;
        int newValue = this.getValue();
        if (oldValue != newValue && newValue >= 0 || this.mFirstCall) {
            this.mFirstCall = false;
            String soundName = newValue > 0 ? "countdown1" : "countdown2";
            this.mAudioManager.play(this.mSoundAtlas.get(soundName), 1.0f);
            if (newValue == 0) {
                this.mGameWorld.startRace();
            }
        }
    }
}

