/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.racescreen;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.GameWorld;
import com.agateau.pixelwheels.racescreen.CountDown;
import com.agateau.pixelwheels.racescreen.Hud;
import com.agateau.ui.anchor.Anchor;
import com.agateau.ui.anchor.AnchorGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;

public class CountDownHudController {
    private final GameWorld mGameWorld;
    private final Hud mHud;
    private final Label mCountDownLabel;

    public CountDownHudController(Assets assets, GameWorld gameWorld, Hud hud) {
        this.mGameWorld = gameWorld;
        this.mHud = hud;
        Skin skin = assets.ui.skin;
        AnchorGroup root = hud.getRoot();
        this.mCountDownLabel = new Label("", skin, "hudCountDown");
        this.mCountDownLabel.setAlignment(4);
        root.addPositionRule(this.mCountDownLabel, Anchor.BOTTOM_CENTER, root, Anchor.CENTER);
    }

    public Hud getHud() {
        return this.mHud;
    }

    public void act(float delta) {
        CountDown countDown = this.mGameWorld.getCountDown();
        if (countDown.isFinished()) {
            this.mCountDownLabel.setVisible(false);
            return;
        }
        float alpha = countDown.getPercent();
        int count = countDown.getValue();
        this.mCountDownLabel.setColor(1.0f, 1.0f, 1.0f, alpha);
        String text = count > 0 ? String.valueOf(count) : "GO!";
        this.mCountDownLabel.setText(text);
    }
}

