/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.racescreen;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.ZLevel;
import com.agateau.pixelwheels.gameobject.AudioClipper;
import com.agateau.pixelwheels.gameobject.GameObjectAdapter;
import com.agateau.pixelwheels.map.Track;
import com.agateau.pixelwheels.racer.HoleHandlerComponent;
import com.agateau.pixelwheels.racer.Vehicle;
import com.agateau.pixelwheels.sound.AudioManager;
import com.agateau.pixelwheels.sound.SoundPlayer;
import com.agateau.pixelwheels.utils.OrientedPoint;
import com.agateau.utils.AgcMathUtils;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.ReflectionPool;

public class Helicopter
extends GameObjectAdapter
implements Pool.Poolable,
Disposable {
    private static final float SHADOW_OFFSET = 80.0f;
    private static final Vector2 BODY_CENTER = new Vector2(30.0f, 76.0f);
    private static final float PROPELLER_SPEED = -720.0f;
    private static final float MAX_SPEED = 20.0f;
    private static final float SLOW_DOWN_DISTANCE = 5.0f;
    private static final float MIN_PITCH = 0.7f;
    private static final float MAX_PITCH = 1.3f;
    private static final float ANGLE_TOLERANCE = 4.0f;
    private static final float POSITION_TOLERANCE = 0.2f;
    private static final ReflectionPool<Helicopter> sPool = new ReflectionPool<Helicopter>(Helicopter.class);
    private SoundPlayer mSoundPlayer;
    private FrameBuffer mFrameBuffer;
    private SpriteBatch mFrameBufferBatch;
    private TextureRegion mBodyRegion;
    private TextureRegion mPropellerRegion;
    private TextureRegion mPropellerTopRegion;
    private final Vector2 mPosition = new Vector2();
    private float mAngle;
    private final Vector2 mSpawnPosition = new Vector2();
    private final Vector2 mEndPosition = new Vector2();
    private float mEndAngle;
    private float mTime;
    private State mState;
    private float mFrameBufferRadiusU;
    private final Vector2 mTmpVec = new Vector2();
    private float mSpeed = 20.0f;

    private static void decideSpawnPosition(Assets assets, Track track, Helicopter helicopter, Vector2 vehiclePos) {
        float halfWidth = 0.05f * (float)assets.helicopterBody.getRegionWidth() / 2.0f;
        float halfHeight = 0.05f * (float)assets.helicopterBody.getRegionHeight() / 2.0f;
        float mapWidth = track.getMapWidth();
        float mapHeight = track.getMapHeight();
        float left = vehiclePos.x;
        float bottom = vehiclePos.y;
        float right = mapWidth - vehiclePos.x;
        float top = mapHeight - vehiclePos.y;
        float startX = -halfWidth;
        float startY = vehiclePos.y;
        float distance = left;
        if (distance > right) {
            startX = mapWidth + halfWidth;
            distance = right;
        }
        if (distance > bottom) {
            startX = vehiclePos.x;
            startY = -halfHeight;
            distance = bottom;
        }
        if (distance > top) {
            startX = vehiclePos.x;
            startY = mapHeight + halfHeight;
        }
        helicopter.mSpawnPosition.set(startX, startY);
        helicopter.mAngle = helicopter.mTmpVec.set(vehiclePos).sub(helicopter.mSpawnPosition).angleDeg();
        helicopter.mPosition.set(helicopter.mSpawnPosition);
    }

    public static Helicopter create(Assets assets, AudioManager audioManager, Track track, HoleHandlerComponent holeHandlerComponent) {
        Vehicle vehicle = holeHandlerComponent.getVehicle();
        Helicopter object = (Helicopter)sPool.obtain();
        object.setFinished(false);
        if (object.mSoundPlayer == null) {
            object.mSoundPlayer = audioManager.createSoundPlayer(assets.soundAtlas.get("helicopter"));
        }
        object.mBodyRegion = assets.helicopterBody;
        object.mPropellerRegion = assets.helicopterPropeller;
        object.mPropellerTopRegion = assets.helicopterPropellerTop;
        Helicopter.decideSpawnPosition(assets, track, object, vehicle.getPosition());
        object.mEndPosition.set(vehicle.getPosition());
        object.mEndAngle = vehicle.getAngle();
        object.mTime = 0.0f;
        object.mState = State.ARRIVING;
        if (object.mFrameBuffer == null) {
            int bufferWidth = object.mPropellerRegion.getRegionWidth();
            int bufferHeight = object.mPropellerRegion.getRegionHeight() / 2 + (int)Helicopter.BODY_CENTER.y;
            object.mFrameBuffer = new FrameBuffer(Pixmap.Format.RGBA8888, bufferWidth, bufferHeight, false);
            object.mFrameBufferBatch = new SpriteBatch();
            object.mFrameBufferBatch.setProjectionMatrix(new Matrix4().setToOrtho2D(0.0f, 0.0f, bufferWidth, bufferHeight));
            object.mFrameBufferRadiusU = 0.05f * (Vector2.len((float)bufferWidth / 2.0f, (float)bufferHeight / 2.0f) + 80.0f);
        }
        return object;
    }

    @Override
    public void reset() {
    }

    @Override
    public void dispose() {
        if (this.mSoundPlayer != null) {
            this.mSoundPlayer.stop();
        }
        sPool.free(this);
    }

    public void setDestination(OrientedPoint point) {
        this.mEndPosition.set(point.x, point.y);
        this.mEndAngle = AgcMathUtils.normalizeAngle(point.angle);
    }

    public void setDestination(Vector2 position, float angle) {
        this.mEndPosition.set(position);
        this.mEndAngle = AgcMathUtils.normalizeAngle(angle);
    }

    public float getAngle() {
        return this.mAngle;
    }

    public boolean isAtDestination() {
        return this.mPosition.epsilonEquals(this.mEndPosition, 0.2f) && AgcMathUtils.anglesAreEqual(this.mAngle, this.mEndAngle, 4.0f);
    }

    @Override
    public void act(float delta) {
        this.mTime += delta;
        this.updateFrameBuffer();
        switch (this.mState) {
            case ARRIVING: {
                this.actArriving(delta);
                break;
            }
            case RECOVERING: {
                this.actRecovering(delta);
                break;
            }
            case LEAVING: {
                this.actLeaving(delta);
            }
        }
    }

    @Override
    public void audioRender(AudioClipper clipper) {
        this.mSoundPlayer.setVolume(clipper.clip(this));
        float pitch = MathUtils.random(0.7f, 1.3f);
        this.mSoundPlayer.setPitch(pitch);
        if (!this.mSoundPlayer.isLooping()) {
            this.mSoundPlayer.loop();
        }
    }

    private void actArriving(float delta) {
        this.moveTowardDestination(delta);
    }

    public void switchToRecoveringState() {
        this.mState = State.RECOVERING;
    }

    private void actRecovering(float delta) {
        this.moveTowardDestination(delta);
    }

    public void leave() {
        this.mTime = 0.0f;
        this.mState = State.LEAVING;
        this.mTmpVec.set(this.mSpawnPosition).sub(this.mPosition);
        float angle = this.mTmpVec.angleDeg();
        this.setDestination(this.mSpawnPosition, angle);
    }

    private void actLeaving(float delta) {
        if (this.isAtDestination()) {
            this.setFinished(true);
            this.mSoundPlayer.stop();
            return;
        }
        this.moveTowardDestination(delta);
    }

    private void moveTowardDestination(float delta) {
        this.mTmpVec.set(this.mEndPosition).sub(this.mPosition);
        float distance = this.mTmpVec.len();
        float k = MathUtils.clamp(distance / 5.0f, 0.01f, 1.0f);
        float speed = this.mSpeed;
        if (distance > 5.0f) {
            if (speed < 20.0f) {
                speed += Math.min(20.0f, speed + 2.0f);
            }
        } else {
            speed = 20.0f * k;
        }
        this.mSpeed = speed;
        this.mTmpVec.nor().scl(this.mSpeed * delta);
        this.mPosition.add(this.mTmpVec);
        float targetAngle = distance > 10.0f ? this.mTmpVec.angleDeg() : this.mEndAngle;
        float angleDistance = AgcMathUtils.shortestAngleDelta(this.mAngle, targetAngle);
        float angularSpeed = angleDistance / delta / 10.0f;
        this.mAngle = AgcMathUtils.normalizeAngle(this.mAngle + angularSpeed * delta);
    }

    @Override
    public void draw(Batch batch, ZLevel zLevel, Rectangle viewBounds) {
        if (!AgcMathUtils.rectangleContains(viewBounds, this.getPosition(), this.mFrameBufferRadiusU)) {
            return;
        }
        if (zLevel == ZLevel.FG_LAYERS) {
            float old = batch.getPackedColor();
            batch.setColor(0.0f, 0.0f, 0.0f, 0.35f);
            float offset = 4.0f;
            this.drawFrameBuffer(batch, offset);
            batch.setPackedColor(old);
        } else if (zLevel == ZLevel.FLYING_HIGH) {
            this.drawFrameBuffer(batch, 0.0f);
        }
    }

    private void updateFrameBuffer() {
        float w = this.mBodyRegion.getRegionWidth();
        float h = this.mBodyRegion.getRegionHeight();
        float propellerW = this.mPropellerRegion.getRegionWidth();
        float propellerH = this.mPropellerRegion.getRegionHeight();
        float propellerTopW = this.mPropellerTopRegion.getRegionWidth();
        float propellerTopH = this.mPropellerTopRegion.getRegionHeight();
        this.mFrameBuffer.begin();
        this.mFrameBufferBatch.begin();
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        Gdx.gl.glClear(16384);
        this.mFrameBufferBatch.draw(this.mBodyRegion, propellerW / 2.0f - Helicopter.BODY_CENTER.x, 0.0f, w, h);
        this.mFrameBufferBatch.draw(this.mPropellerRegion, 0.0f, Helicopter.BODY_CENTER.y - propellerH / 2.0f, propellerW / 2.0f, propellerH / 2.0f, propellerW, propellerH, 1.0f, 1.0f, this.mTime * -720.0f % 360.0f);
        this.mFrameBufferBatch.draw(this.mPropellerTopRegion, propellerW / 2.0f - propellerTopW / 2.0f, Helicopter.BODY_CENTER.y - propellerTopH / 2.0f, propellerTopW, propellerTopH);
        this.mFrameBufferBatch.end();
        this.mFrameBuffer.end();
    }

    private void drawFrameBuffer(Batch batch, float offset) {
        float U = 0.05f;
        int w = this.mFrameBuffer.getWidth();
        int h = this.mFrameBuffer.getHeight();
        Texture texture = (Texture)this.mFrameBuffer.getColorBufferTexture();
        batch.draw(texture, this.getX() - (float)w * 0.05f / 2.0f + offset, this.getY() - Helicopter.BODY_CENTER.y * 0.05f - offset, (float)w * 0.05f / 2.0f, Helicopter.BODY_CENTER.y * 0.05f, (float)w * 0.05f, (float)h * 0.05f, 1.0f, 1.0f, this.mAngle - 90.0f, 0, 0, w, h, false, true);
    }

    @Override
    public float getX() {
        return this.mPosition.x;
    }

    @Override
    public float getY() {
        return this.mPosition.y;
    }

    private static enum State {
        ARRIVING,
        RECOVERING,
        LEAVING;

    }
}

