/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.rewards;

import com.agateau.pixelwheels.gamesetup.Difficulty;
import com.agateau.pixelwheels.map.Championship;
import com.agateau.pixelwheels.rewards.RewardRule;
import com.agateau.pixelwheels.stats.GameStats;
import com.agateau.pixelwheels.utils.StringUtils;
import com.agateau.translations.Translator;
import com.agateau.utils.Assert;

public class ChampionshipRankRewardRule
implements RewardRule {
    private final Difficulty mDifficulty;
    private final Championship mChampionship;
    private final int mRank;

    public ChampionshipRankRewardRule(Championship championship, int rank) {
        this(null, championship, rank);
    }

    public ChampionshipRankRewardRule(Difficulty difficulty, Championship championship, int rank) {
        this.mDifficulty = difficulty;
        this.mChampionship = championship;
        this.mRank = rank;
        Assert.check(0 <= rank && rank <= 2, "Rank must be between 0 and 2", new Object[0]);
    }

    @Override
    public boolean hasBeenUnlocked(GameStats gameStats) {
        if (this.mDifficulty == null) {
            return ChampionshipRankRewardRule.getBestBestChampionshipRank(gameStats, this.mChampionship) <= this.mRank;
        }
        return gameStats.getBestChampionshipRank(this.mDifficulty, this.mChampionship) <= this.mRank;
    }

    @Override
    public String getUnlockText(GameStats gameStats) {
        if (this.mDifficulty == null) {
            String msg = this.mRank == 2 ? Translator.tr("Finish third or better at %s championship") : (this.mRank == 1 ? Translator.tr("Finish second or better at %s championship") : Translator.tr("Finish first at %s championship"));
            return StringUtils.format(msg, this.mChampionship.getName());
        }
        String msg = this.mRank == 2 ? Translator.tr("Finish third or better at %s championship in %s league") : (this.mRank == 1 ? Translator.tr("Finish second or better at %s championship in %s league") : Translator.tr("Finish first at %s championship in %s league"));
        return StringUtils.format(msg, this.mChampionship.getName(), this.mDifficulty.toTranslatedString());
    }

    public static int getBestBestChampionshipRank(GameStats gameStats, Championship championship) {
        int best = Integer.MAX_VALUE;
        for (Difficulty difficulty : Difficulty.values()) {
            best = Math.min(best, gameStats.getBestChampionshipRank(difficulty, championship));
        }
        return best;
    }
}

