/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.screens;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.PwGame;
import com.agateau.pixelwheels.PwRefreshHelper;
import com.agateau.pixelwheels.map.Championship;
import com.agateau.pixelwheels.map.Track;
import com.agateau.pixelwheels.screens.ChampionshipSelector;
import com.agateau.pixelwheels.screens.PwStageScreen;
import com.agateau.translations.Translator;
import com.agateau.ui.anchor.AnchorGroup;
import com.agateau.ui.menu.GridMenuItem;
import com.agateau.ui.menu.Menu;
import com.agateau.ui.uibuilder.UiBuilder;
import com.agateau.utils.FileUtils;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;

public class SelectChampionshipScreen
extends PwStageScreen {
    private final PwGame mGame;
    private final Listener mListener;
    private Label mChampionshipNameLabel;
    private Label mChampionshipDetailsLabel;
    private ChampionshipSelector mChampionshipSelector;
    private Button mNextButton;
    private final StringBuilder mStringBuilder = new StringBuilder();

    public SelectChampionshipScreen(PwGame game, Listener listener, final String championshipId) {
        super(game.getAssets().ui);
        this.mGame = game;
        this.mListener = listener;
        Championship championship = this.findChampionship(championshipId);
        this.setupUi(championship);
        new PwRefreshHelper(this.mGame, this.getStage()){

            @Override
            protected void refresh() {
                SelectChampionshipScreen.this.mGame.replaceScreen(new SelectChampionshipScreen(SelectChampionshipScreen.this.mGame, SelectChampionshipScreen.this.mListener, championshipId));
            }
        };
    }

    private Championship findChampionship(String championshipId) {
        Championship championship = this.mGame.getAssets().findChampionshipById(championshipId);
        if (championship == null) {
            championship = this.mGame.getAssets().championships.get(0);
        }
        return championship;
    }

    private void setupUi(Championship championship) {
        Assets assets = this.mGame.getAssets();
        UiBuilder builder = new UiBuilder(assets.atlas, assets.ui.skin);
        AnchorGroup root = (AnchorGroup)builder.build(FileUtils.assets("screens/selectchampionship.gdxui"));
        root.setFillParent(true);
        this.getStage().addActor(root);
        this.mChampionshipNameLabel = (Label)builder.getActor("championshipNameLabel");
        this.mChampionshipDetailsLabel = (Label)builder.getActor("championshipDetailsLabel");
        Menu menu = (Menu)builder.getActor("menu");
        this.createChampionshipSelector(championship, menu);
        this.updateChampionshipDetails(championship);
        menu.addBackButton().addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                SelectChampionshipScreen.this.onBackPressed();
            }
        });
        this.mNextButton = menu.addNextButton();
        this.mNextButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                SelectChampionshipScreen.this.next();
            }
        });
        this.updateNextButton();
    }

    private void updateNextButton() {
        this.mNextButton.setDisabled(!this.mChampionshipSelector.isCurrentItemEnabled());
    }

    private void createChampionshipSelector(Championship championship, Menu menu) {
        Assets assets = this.mGame.getAssets();
        this.mChampionshipSelector = new ChampionshipSelector(menu);
        this.mChampionshipSelector.setMenuStyle(menu.getMenuStyleByName("large"));
        this.mChampionshipSelector.setColumnCount(3);
        this.mChampionshipSelector.init(assets, this.mGame.getRewardManager());
        this.mChampionshipSelector.setCurrent(championship);
        menu.addItem(this.mChampionshipSelector);
        this.mChampionshipSelector.setSelectionListener(new GridMenuItem.SelectionListener<Championship>(){

            @Override
            public void currentChanged(Championship championship, int index) {
                SelectChampionshipScreen.this.updateChampionshipDetails(championship);
                SelectChampionshipScreen.this.updateNextButton();
            }

            @Override
            public void selectionConfirmed() {
                SelectChampionshipScreen.this.next();
            }
        });
    }

    private void updateChampionshipDetails(Championship championship) {
        if (this.mGame.getRewardManager().isChampionshipUnlocked(championship)) {
            this.mChampionshipNameLabel.setText(championship.getName());
            this.mStringBuilder.setLength(0);
            boolean first = true;
            for (Track track : championship.getTracks()) {
                if (first) {
                    first = false;
                } else {
                    this.mStringBuilder.append('\n');
                }
                this.mStringBuilder.append(track.getMapName());
            }
            this.mChampionshipDetailsLabel.setText(this.mStringBuilder.toString());
        } else {
            this.mChampionshipNameLabel.setText(Translator.tr("[Locked]"));
            this.mChampionshipDetailsLabel.setText(this.mGame.getRewardManager().getUnlockText(championship));
        }
        this.mChampionshipNameLabel.pack();
        this.mChampionshipDetailsLabel.pack();
    }

    @Override
    public void onBackPressed() {
        this.mListener.onBackPressed();
    }

    private void next() {
        if (!this.mChampionshipSelector.isCurrentItemEnabled()) {
            return;
        }
        this.mListener.onChampionshipSelected((Championship)this.mChampionshipSelector.getCurrent());
    }

    public static interface Listener {
        public void onBackPressed();

        public void onChampionshipSelected(Championship var1);
    }
}

