/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.screens;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.utils.DrawUtils;
import com.agateau.pixelwheels.vehicledef.AxleDef;
import com.agateau.pixelwheels.vehicledef.VehicleDef;
import com.agateau.ui.GLViewportSaver;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;

public class VehicleDrawer {
    private static final int FB_WIDTH = 128;
    private static final int FB_HEIGHT = 128;
    private final Assets mAssets;
    private final Rectangle mRectangle = new Rectangle();
    private final FrameBuffer mFrameBuffer;
    private final Vector2 mFrameBufferCenter = new Vector2(64.0f, 64.0f);
    private final Matrix4 mFrameBufferProjectionMatrix = new Matrix4();
    private final Matrix4 mFrameBufferTransformMatrix = new Matrix4();
    private final GLViewportSaver mViewportSaver = new GLViewportSaver();
    private VehicleDef mVehicleDef;
    private final Vector2 mCenter = new Vector2(0.0f, 0.0f);
    private float mAngle = 90.0f;
    private final Vector2 sWheelPos = new Vector2();
    private static final Matrix4 sOldMatrix = new Matrix4();
    private static final Matrix4 sOldTransformMatrix = new Matrix4();

    public VehicleDrawer(Assets assets) {
        this.mAssets = assets;
        this.mFrameBuffer = new FrameBuffer(Pixmap.Format.RGBA8888, 128, 128, false);
        this.mFrameBufferProjectionMatrix.setToOrtho2D(0.0f, 0.0f, 128.0f, 128.0f);
    }

    public void setVehicleDef(VehicleDef vehicleDef) {
        this.mVehicleDef = vehicleDef;
    }

    public void setAngle(float angle) {
        this.mAngle = angle;
    }

    public void setCenter(float x, float y) {
        this.mCenter.set(x, y);
    }

    public Rectangle getRectangle() {
        TextureRegion region = this.mVehicleDef.getImage(this.mAssets);
        float halfHeight = (float)region.getRegionWidth() / 2.0f;
        float halfWidth = (float)region.getRegionHeight() / 2.0f;
        float axleYOrigin = -halfHeight;
        float bottom = -halfHeight;
        float top = halfHeight;
        for (AxleDef axle : this.mVehicleDef.axles) {
            float axleY = axleYOrigin + axle.y;
            TextureRegion wheelRegion = axle.getTexture(this.mAssets);
            float thickness = wheelRegion.getRegionHeight();
            float diameter = wheelRegion.getRegionWidth();
            float wheelRight = axle.width / 2.0f + thickness / 2.0f;
            float wheelBottom = axleY - diameter / 2.0f;
            float wheelTop = axleY + diameter / 2.0f;
            halfWidth = Math.max(halfWidth, wheelRight);
            bottom = Math.min(bottom, wheelBottom);
            top = Math.max(top, wheelTop);
        }
        this.mRectangle.width = halfWidth * 2.0f;
        this.mRectangle.height = top - bottom;
        this.mRectangle.x = this.mCenter.x - halfWidth;
        this.mRectangle.y = this.mCenter.y + bottom;
        return this.mRectangle;
    }

    public void draw(Batch batch) {
        TextureRegion region = this.mVehicleDef.getImage(this.mAssets);
        batch.end();
        sOldMatrix.set(batch.getProjectionMatrix());
        sOldTransformMatrix.set(batch.getTransformMatrix());
        batch.setProjectionMatrix(this.mFrameBufferProjectionMatrix);
        batch.setTransformMatrix(this.mFrameBufferTransformMatrix);
        this.mViewportSaver.save();
        this.mFrameBuffer.begin();
        batch.begin();
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        Gdx.gl.glClear(16384);
        this.drawInternal(batch, region, this.mFrameBufferCenter);
        batch.end();
        FrameBuffer.unbind();
        this.mViewportSaver.restore();
        batch.setProjectionMatrix(sOldMatrix);
        batch.setTransformMatrix(sOldTransformMatrix);
        batch.begin();
        this.drawFrameBuffer(batch);
        this.drawInternal(batch, region, this.mCenter);
    }

    private void drawFrameBuffer(Batch batch) {
        float oldColor = batch.getPackedColor();
        batch.setColor(0.0f, 0.0f, 0.0f, 0.35f);
        batch.draw((Texture)this.mFrameBuffer.getColorBufferTexture(), this.mCenter.x - 64.0f + 3.0f, this.mCenter.y - 64.0f - 3.0f, 128.0f, 128.0f, 0, 0, 128, 128, false, true);
        batch.setPackedColor(oldColor);
    }

    private void drawInternal(Batch batch, TextureRegion region, Vector2 center) {
        float axleXOrigin = (float)(-region.getRegionWidth()) / 2.0f;
        for (AxleDef axle : this.mVehicleDef.axles) {
            float axleX = axleXOrigin + axle.y;
            TextureRegion wheelRegion = axle.getTexture(this.mAssets);
            this.drawWheel(batch, wheelRegion, center, axleX, -axle.width / 2.0f);
            this.drawWheel(batch, wheelRegion, center, axleX, axle.width / 2.0f);
        }
        DrawUtils.drawCentered(batch, region, center.x, center.y, 1.0f, this.mAngle);
    }

    private void drawWheel(Batch batch, TextureRegion region, Vector2 center, float wx, float wy) {
        this.sWheelPos.set(wx, wy).rotateDeg(this.mAngle).add(center);
        DrawUtils.drawCentered(batch, region, this.sWheelPos, 1.0f, this.mAngle);
    }
}

