/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui;

import com.agateau.utils.Assert;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Table;

public abstract class TableRowCreator {
    public static final String HEADER_STYLE = "tableHeaderRow";
    private final int mColumns;
    private Table mTable;
    private String mNextStyle = "";
    private int mPadding = 0;

    protected abstract Cell createCell(Table var1, int var2, String var3, String var4);

    public TableRowCreator(int columns) {
        this.mColumns = columns;
    }

    public void setTable(Table table) {
        this.mTable = table;
    }

    public void setSpacing(int padding) {
        this.mPadding = padding;
    }

    public void setRowStyle(String style) {
        this.mNextStyle = style;
    }

    public void addRow(String ... values) {
        Assert.check(values.length == this.mColumns, "Wrong number of columns", new Object[0]);
        for (int column = 0; column < this.mColumns; ++column) {
            Cell cell = this.createCell(this.mTable, column, values[column], this.mNextStyle);
            if (column >= this.mColumns - 1) continue;
            cell.padRight(this.mPadding);
        }
        this.mTable.row();
    }

    public <T extends Actor> Cell<T> getCreatedRowCell(int column) {
        if (column < 0) {
            column += this.mColumns;
        }
        return this.mTable.getCells().get(this.mTable.getCells().size - this.mColumns + column);
    }

    public void addHeaderRow(String ... values) {
        this.setRowStyle(HEADER_STYLE);
        this.addRow(values);
    }
}

