/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui;

import com.agateau.ui.menu.GridMenuItem;
import com.agateau.utils.Assert;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;

public abstract class TextureRegionItemRendererAdapter<T>
implements GridMenuItem.ItemRenderer<T> {
    private final Rectangle mRectangle = new Rectangle();
    private float mScale = 1.0f;
    private float mAngle = 0.0f;

    public void setAngle(float angle) {
        Assert.check(angle % 90.0f == 0.0f, "Angle must be a multiple of 90", new Object[0]);
        this.mAngle = angle;
    }

    @Override
    public Rectangle getItemRectangle(float width, float height, T item) {
        TextureRegion region = this.getItemRegion(item);
        this.updateRenderInfo(width, height, region);
        return this.mRectangle;
    }

    @Override
    public void render(Batch batch, float x, float y, float width, float height, T item) {
        TextureRegion region = this.getItemRegion(item);
        this.updateRenderInfo(width, height, region);
        float rWidth = region.getRegionWidth();
        float rHeight = region.getRegionHeight();
        batch.draw(region, x + (width - rWidth) / 2.0f, y + (height - rHeight) / 2.0f, rWidth / 2.0f, rHeight / 2.0f, rWidth, rHeight, this.mScale, this.mScale, this.mAngle);
    }

    @Override
    public boolean isItemEnabled(T item) {
        return true;
    }

    protected abstract TextureRegion getItemRegion(T var1);

    protected void updateRenderInfo(float width, float height, TextureRegion region) {
        float rWidth = region.getRegionWidth();
        float rHeight = region.getRegionHeight();
        if (this.mAngle % 180.0f > 0.0f) {
            float tmp = rHeight;
            rHeight = rWidth;
            rWidth = tmp;
        }
        float xScale = width / rWidth;
        float yScale = height / rHeight;
        this.mScale = Math.min(Math.min(xScale, yScale), 1.0f);
        this.mRectangle.width = rWidth * this.mScale;
        this.mRectangle.height = rHeight * this.mScale;
        this.mRectangle.x = (width - this.mRectangle.width) / 2.0f;
        this.mRectangle.y = (height - this.mRectangle.height) / 2.0f;
    }

    public float getScale() {
        return this.mScale;
    }

    public float getAngle() {
        return this.mAngle;
    }
}

