/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui;

import com.agateau.ui.GamepadInputMapper;
import com.agateau.ui.GamepadInputMappers;
import com.agateau.ui.InputMapper;
import com.agateau.ui.KeyMapper;
import com.agateau.ui.VirtualKey;
import com.badlogic.gdx.Preferences;

public class UiInputMapper
implements InputMapper {
    private final KeyMapper mKeyMapper = KeyMapper.createUiInstance();
    private final GamepadInputMapper mGamepadInputMapper = GamepadInputMappers.getInstance().getMappers()[0];
    private static UiInputMapper sInstance;

    private UiInputMapper() {
    }

    public static UiInputMapper getInstance() {
        if (sInstance == null) {
            sInstance = new UiInputMapper();
        }
        return sInstance;
    }

    public KeyMapper getKeyMapper() {
        return this.mKeyMapper;
    }

    @Override
    public boolean isKeyPressed(VirtualKey key) {
        return this.mKeyMapper.isKeyPressed(key) || this.mGamepadInputMapper.isKeyPressed(key);
    }

    @Override
    public boolean isKeyJustPressed(VirtualKey key) {
        return this.mKeyMapper.isKeyJustPressed(key) || this.mGamepadInputMapper.isKeyJustPressed(key);
    }

    @Override
    public void loadConfig(Preferences preferences, String prefix, int playerIdx) {
    }

    @Override
    public void saveConfig(Preferences preferences, String prefix) {
    }

    @Override
    public boolean isAvailable() {
        return true;
    }
}

