/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.utils;

import com.agateau.utils.log.NLog;
import com.badlogic.gdx.files.FileHandle;
import java.io.IOException;
import java.io.Writer;
import java.util.Locale;

public class CsvWriter {
    private final Writer mWriter;
    private char mFieldSeparator = (char)59;

    public CsvWriter(FileHandle handle) {
        this.mWriter = handle.writer(false);
    }

    public void setFieldSeparator(char separator) {
        this.mFieldSeparator = separator;
    }

    public void addRow(Object ... args) {
        try {
            int n = args.length;
            for (int i = 0; i < n; ++i) {
                Object value;
                if (i > 0) {
                    this.mWriter.append(this.mFieldSeparator);
                }
                String text = (value = args[i]) instanceof Float ? String.format(Locale.US, "%f", (Float)value) : value.toString();
                this.mWriter.append(text);
            }
            this.mWriter.append('\n');
            this.mWriter.flush();
        }
        catch (IOException e) {
            NLog.e("Failed to write CSV file", new Object[0]);
            e.printStackTrace();
        }
    }
}

