/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.utils;

import java.io.File;
import java.util.Map;

public class DesktopDirs {
    private final String mAppName;
    private final Map<String, String> mEnvironment;

    public DesktopDirs(String appName, Map<String, String> environment) {
        this.mAppName = appName;
        this.mEnvironment = environment;
    }

    public String getConfigDir() {
        return this.getXdgDir("XDG_CONFIG_HOME", ".config") + File.separator + this.mAppName;
    }

    public String getCacheDir() {
        return this.getXdgDir("XDG_CACHE_HOME", ".cache") + File.separator + this.mAppName;
    }

    public String getDataDir() {
        return this.getXdgDir("XDG_DATA_HOME", ".local" + File.separator + "share") + File.separator + this.mAppName;
    }

    private String getXdgDir(String variableName, String defaultSubDir) {
        String dir = this.mEnvironment.get(variableName);
        if (dir != null) {
            return dir;
        }
        String homeDir = System.getProperty("user.home");
        if (homeDir == null) {
            System.err.println("Can't find user home dir, using current dir");
            homeDir = System.getProperty("user.dir");
            if (homeDir == null) {
                throw new RuntimeException("Can't find current dir, aborting");
            }
        }
        return homeDir + File.separator + defaultSubDir;
    }
}

