/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.utils.log;

import com.agateau.utils.log.NLog;
import com.agateau.utils.log.NLogPrinterUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class LogFilePrinter
implements NLog.Printer {
    public static final String BACKUP_SUFFIX = ".0";
    private final String mPath;
    private final LogFileOpener mOpener;
    private final long mMaxSize;
    private MessageFormatter mFormatter;
    private FileOutputStream mStream;
    private long mCurrentSize;
    private static final MessageFormatter sDefaultMessageFormatter = new MessageFormatter(){
        private final StringBuilder mStringBuilder = new StringBuilder();

        @Override
        public String formatMessage(NLog.Level level, String tag, String message) {
            String levelString = level == NLog.Level.DEBUG ? "D" : (level == NLog.Level.INFO ? "I" : "E");
            this.mStringBuilder.setLength(0);
            NLogPrinterUtils.appendTimeStamp(this.mStringBuilder);
            this.mStringBuilder.append(' ');
            this.mStringBuilder.append(levelString);
            this.mStringBuilder.append(' ');
            this.mStringBuilder.append(tag);
            this.mStringBuilder.append(' ');
            this.mStringBuilder.append(message);
            return this.mStringBuilder.toString();
        }
    };

    public String getPath() {
        return this.mPath;
    }

    public void flush() {
        try {
            this.mStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public LogFilePrinter(String path, long maxSize) {
        this(path, maxSize, filename -> {
            try {
                return new FileOutputStream(filename, true);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                return null;
            }
        });
    }

    public LogFilePrinter(String path, long maxSize, LogFileOpener opener) {
        this.mPath = path;
        this.mMaxSize = maxSize;
        this.mOpener = opener;
        this.mFormatter = sDefaultMessageFormatter;
        File file = new File(path);
        this.mCurrentSize = file.exists() ? file.length() : 0L;
        this.openFile();
    }

    public void setMessageFormatter(MessageFormatter messageFormatter) {
        this.mFormatter = messageFormatter;
    }

    @Override
    public void print(NLog.Level level, String tag, String message) {
        if (this.mStream == null) {
            return;
        }
        if (this.mCurrentSize + (long)(message = this.mFormatter.formatMessage(level, tag, message)).length() + 1L > this.mMaxSize) {
            this.rotateLogFile();
        }
        try {
            this.mStream.write(message.getBytes());
            this.mStream.write(10);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void rotateLogFile() {
        try {
            this.mStream.flush();
            this.mStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File file = new File(this.mPath);
        file.renameTo(new File(this.mPath + BACKUP_SUFFIX));
        this.mCurrentSize = 0L;
        this.openFile();
    }

    private void openFile() {
        if (this.mStream != null) {
            try {
                this.mStream.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                this.mStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.mStream = this.mOpener.openLogFile(this.mPath);
    }

    public static interface LogFileOpener {
        public FileOutputStream openLogFile(String var1);
    }

    public static interface MessageFormatter {
        public String formatMessage(NLog.Level var1, String var2, String var3);
    }
}

