/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import apple.laf.JRSUIStateFactory;
import apple.laf.JRSUIUtils;
import com.apple.laf.AquaFocusHandler;
import com.apple.laf.AquaGroupBorder;
import com.apple.laf.AquaIcon;
import com.apple.laf.AquaImageFactory;
import com.apple.laf.AquaPainter;
import com.apple.laf.AquaTabbedPaneCopyFromBasicUI;
import com.apple.laf.AquaTabbedPaneTabState;
import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class AquaTabbedPaneUI
extends AquaTabbedPaneCopyFromBasicUI {
    private static final int kSmallTabHeight = 20;
    private static final int kLargeTabHeight = 23;
    private static final int kMaxIconSize = 16;
    private static final double kNinetyDegrees = 1.5707963267948966;
    protected final Insets currentContentDrawingInsets = new Insets(0, 0, 0, 0);
    protected final Insets currentContentBorderInsets = new Insets(0, 0, 0, 0);
    protected final Insets contentDrawingInsets = new Insets(0, 0, 0, 0);
    protected int pressedTab = -3;
    protected boolean popupSelectionChanged;
    protected Boolean isDefaultFocusReceiver = null;
    protected boolean hasAvoidedFirstFocus = false;
    protected final AquaTabbedPaneTabState visibleTabState = new AquaTabbedPaneTabState(this);
    protected final AquaPainter<JRSUIState> painter = AquaPainter.create(JRSUIStateFactory.getTab());
    final Rectangle fContentRect = new Rectangle();
    final Rectangle fIconRect = new Rectangle();
    final Rectangle fTextRect = new Rectangle();
    static AlterRects[] alterRects = new AlterRects[5];
    private static final int TAB_BORDER_INSET = 9;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaTabbedPaneUI();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        if (this.mouseListener != null) {
            this.tabPane.addMouseMotionListener((MouseMotionListener)((Object)this.mouseListener));
        }
    }

    @Override
    protected void installDefaults() {
        Boolean bl;
        super.installDefaults();
        if (this.tabPane.getFont() instanceof UIResource && (bl = (Boolean)UIManager.get("TabbedPane.useSmallLayout")) != null && bl == Boolean.TRUE) {
            this.tabPane.setFont(UIManager.getFont("TabbedPane.smallFont"));
            ((JRSUIState)this.painter.state).set(JRSUIConstants.Size.SMALL);
        }
        this.contentDrawingInsets.set(0, 11, 13, 10);
        this.tabPane.setOpaque(false);
    }

    @Override
    protected void assureRectsCreated(int n) {
        this.visibleTabState.init(n);
        super.assureRectsCreated(n);
    }

    @Override
    protected void uninstallDefaults() {
        this.contentDrawingInsets.set(0, 0, 0, 0);
    }

    @Override
    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    @Override
    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new TabbedPanePropertyChangeHandler();
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new AquaTruncatingTabbedPaneLayout();
    }

    protected boolean shouldRepaintSelectedTabOnMouseDown() {
        return false;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        boolean bl;
        ((JRSUIState)this.painter.state).set(this.getDirection());
        int n = this.tabPane.getTabPlacement();
        int n2 = this.tabPane.getSelectedIndex();
        this.paintContentBorder(graphics, n, n2);
        this.ensureCurrentLayout();
        Rectangle rectangle = graphics.getClipBounds();
        boolean bl2 = this.tabPane.isEnabled();
        boolean bl3 = AquaFocusHandler.isActive(this.tabPane);
        boolean bl4 = bl = this.tabPane.getComponentOrientation().isLeftToRight() || n == 2 || n == 4;
        if (this.visibleTabState.needsScrollTabs()) {
            this.paintScrollingTabs(graphics, rectangle, n, n2, bl2, bl3, bl);
            return;
        }
        this.paintAllTabs(graphics, rectangle, n, n2, bl2, bl3, bl);
    }

    protected void paintAllTabs(Graphics graphics, Rectangle rectangle, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = false;
        for (int i = 0; i < this.rects.length; ++i) {
            if (i == n2) {
                bl4 = true;
                continue;
            }
            if (!this.rects[i].intersects(rectangle)) continue;
            this.paintTabNormal(graphics, n, i, bl, bl2, bl3);
        }
        if (bl4 && this.rects[n2].intersects(rectangle)) {
            this.paintTabNormal(graphics, n, n2, bl, bl2, bl3);
        }
    }

    protected void paintScrollingTabs(Graphics graphics, Rectangle rectangle, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        for (int i = 0; i < this.visibleTabState.getTotal(); ++i) {
            int n3 = this.visibleTabState.getIndex(i);
            if (n3 == n2 || !this.rects[n3].intersects(rectangle)) continue;
            this.paintTabNormal(graphics, n, n3, bl, bl2, bl3);
        }
        Rectangle rectangle2 = this.visibleTabState.getLeftScrollTabRect();
        if (this.visibleTabState.needsLeftScrollTab() && rectangle2.intersects(rectangle)) {
            this.paintTabNormalFromRect(graphics, n, rectangle2, -2, this.fIconRect, this.fTextRect, this.visibleTabState.needsLeftScrollTab(), bl2, bl3);
        }
        Rectangle rectangle3 = this.visibleTabState.getRightScrollTabRect();
        if (this.visibleTabState.needsRightScrollTab() && rectangle3.intersects(rectangle)) {
            this.paintTabNormalFromRect(graphics, n, rectangle3, -1, this.fIconRect, this.fTextRect, this.visibleTabState.needsRightScrollTab(), bl2, bl3);
        }
        if (n2 >= 0) {
            this.paintTabNormal(graphics, n, n2, bl, bl2, bl3);
        }
    }

    private static boolean isScrollTabIndex(int n) {
        return n == -1 || n == -2;
    }

    protected static void transposeRect(Rectangle rectangle) {
        int n = rectangle.y;
        rectangle.y = rectangle.x;
        rectangle.x = n;
        n = rectangle.width;
        rectangle.width = rectangle.height;
        rectangle.height = n;
    }

    @Override
    protected int getTabLabelShiftX(int n, int n2, boolean bl) {
        Rectangle rectangle = n2 >= 0 ? this.rects[n2] : this.visibleTabState.getRightScrollTabRect();
        int n3 = 0;
        switch (n) {
            case 2: 
            case 4: {
                n3 = rectangle.height % 2;
                break;
            }
            default: {
                n3 = rectangle.width % 2;
            }
        }
        return n3;
    }

    @Override
    protected int getTabLabelShiftY(int n, int n2, boolean bl) {
        switch (n) {
            case 2: 
            case 3: 
            case 4: {
                return -1;
            }
        }
        return 0;
    }

    protected Icon getIconForScrollTab(int n, int n2, boolean bl) {
        int n3;
        boolean bl2;
        boolean bl3 = bl2 = !AquaUtils.isLeftToRight(this.tabPane);
        if (n == 4) {
            bl2 = false;
        }
        if (n == 2) {
            bl2 = true;
        }
        int n4 = n3 = n2 == -1 ? 3 : 7;
        if (bl2) {
            if (n3 == 3) {
                n3 = 7;
            } else if (n3 == 7) {
                n3 = 3;
            }
        }
        if (bl) {
            return AquaImageFactory.getArrowIconForDirection(n3);
        }
        Image image = AquaImageFactory.getArrowImageForDirection(n3);
        return new ImageIcon(AquaUtils.generateDisabledImage(image));
    }

    protected void paintContents(Graphics graphics, int n, int n2, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl) {
        boolean bl2;
        Icon icon;
        String string;
        Component component;
        Shape shape = graphics.getClip();
        graphics.clipRect(this.fContentRect.x, this.fContentRect.y, this.fContentRect.width, this.fContentRect.height);
        if (AquaTabbedPaneUI.isScrollTabIndex(n2)) {
            component = null;
            string = null;
            icon = this.getIconForScrollTab(n, n2, true);
        } else {
            component = this.getTabComponentAt(n2);
            if (component == null) {
                string = this.tabPane.getTitleAt(n2);
                icon = this.getIconForTab(n2);
            } else {
                string = null;
                icon = null;
            }
        }
        boolean bl3 = bl2 = n == 4 || n == 2;
        if (bl2) {
            AquaTabbedPaneUI.transposeRect(this.fContentRect);
        }
        Font font = this.tabPane.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        this.layoutLabel(n, fontMetrics, n2 < 0 ? 0 : n2, string, icon, this.fContentRect, rectangle2, rectangle3, false);
        if (bl2) {
            AquaTabbedPaneUI.transposeRect(this.fContentRect);
            AquaTabbedPaneUI.transposeRect(rectangle2);
            AquaTabbedPaneUI.transposeRect(rectangle3);
        }
        if (!(graphics instanceof Graphics2D)) {
            graphics.setClip(shape);
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = null;
        if (bl2) {
            affineTransform = graphics2D.getTransform();
            this.rotateGraphics(graphics2D, rectangle, rectangle3, rectangle2, n);
        }
        if (component == null && n2 >= 0) {
            this.paintTitle(graphics2D, font, fontMetrics, rectangle3, n2, string);
        }
        if (icon != null) {
            this.paintIcon(graphics, n, n2, icon, rectangle2, bl);
        }
        if (affineTransform != null) {
            graphics2D.setTransform(affineTransform);
        }
        graphics.setClip(shape);
    }

    protected void paintTitle(Graphics2D graphics2D, Font font, FontMetrics fontMetrics, Rectangle rectangle, int n, String string) {
        View view = this.getTextViewForTab(n);
        if (view != null) {
            view.paint(graphics2D, rectangle);
            return;
        }
        if (string == null) {
            return;
        }
        Color color = this.tabPane.getForegroundAt(n);
        if (color instanceof UIResource) {
            if (this.tabPane.isEnabledAt(n)) {
                graphics2D.setColor(Color.black);
            } else {
                graphics2D.setColor(Color.gray);
            }
        } else {
            graphics2D.setColor(color);
        }
        graphics2D.setFont(font);
        SwingUtilities2.drawString((JComponent)this.tabPane, (Graphics)graphics2D, string, rectangle.x, rectangle.y + fontMetrics.getAscent());
    }

    protected void rotateGraphics(Graphics2D graphics2D, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        double d = n == 2 ? -1.5707963267948966 : 1.5707963267948966;
        graphics2D.transform(AffineTransform.getRotateInstance(d, rectangle.x, rectangle.y));
        if (n == 2) {
            graphics2D.translate(-rectangle.height - 1, 1);
            n3 = rectangle2.x - rectangle.x;
            n2 = rectangle.height + rectangle.y - (rectangle2.y + rectangle2.height);
            n5 = rectangle3.x - rectangle.x;
            n4 = rectangle.height + rectangle.y - (rectangle3.y + rectangle3.height);
        } else {
            graphics2D.translate(0, -rectangle.width - 1);
            n2 = rectangle2.y - rectangle.y;
            n3 = rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width);
            n4 = rectangle3.y - rectangle.y;
            n5 = rectangle.x + rectangle.width - (rectangle3.x + rectangle3.width);
        }
        rectangle2.x = rectangle.x + n2;
        rectangle2.y = rectangle.y + n3;
        int n6 = rectangle2.height;
        rectangle2.height = rectangle2.width;
        rectangle2.width = n6;
        rectangle3.x = rectangle.x + n4;
        rectangle3.y = rectangle.y + n5;
        n6 = rectangle3.height;
        rectangle3.height = rectangle3.width;
        rectangle3.width = n6;
    }

    protected void paintTabNormal(Graphics graphics, int n, int n2, boolean bl, boolean bl2, boolean bl3) {
        this.paintTabNormalFromRect(graphics, n, this.rects[n2], n2, this.fIconRect, this.fTextRect, bl, bl2, bl3);
    }

    protected void paintTabNormalFromRect(Graphics graphics, int n, Rectangle rectangle, int n2, Rectangle rectangle2, Rectangle rectangle3, boolean bl, boolean bl2, boolean bl3) {
        int n3 = this.tabPane.getSelectedIndex();
        boolean bl4 = n3 == n2;
        this.paintCUITab(graphics, n, rectangle, bl4, bl2, bl3, n2);
        rectangle3.setBounds(rectangle);
        this.fContentRect.setBounds(rectangle);
        this.paintContents(graphics, n, n2, rectangle, rectangle2, rectangle3, bl4);
    }

    protected void paintCUITab(Graphics graphics, int n, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3, int n2) {
        boolean bl4;
        int n3 = this.tabPane.getTabCount();
        boolean bl5 = this.visibleTabState.needsLeftScrollTab();
        boolean bl6 = this.visibleTabState.needsRightScrollTab();
        boolean bl7 = n2 == 0;
        boolean bl8 = bl4 = n2 == n3 - 1;
        if (bl5 || bl6) {
            if (n2 == -1) {
                bl7 = false;
                bl4 = true;
            } else if (n2 == -2) {
                bl7 = true;
                bl4 = false;
            } else {
                if (bl5) {
                    bl7 = false;
                }
                if (bl6) {
                    bl4 = false;
                }
            }
        }
        if (n == 2 || n == 4) {
            boolean bl9 = bl4;
            bl4 = bl7;
            bl7 = bl9;
        }
        JRSUIConstants.State state = this.getState(n2, bl2, bl);
        ((JRSUIState)this.painter.state).set(state);
        ((JRSUIState)this.painter.state).set(bl || state == JRSUIConstants.State.INACTIVE && bl2 ? JRSUIConstants.BooleanValue.YES : JRSUIConstants.BooleanValue.NO);
        ((JRSUIState)this.painter.state).set(AquaTabbedPaneUI.getSegmentPosition(bl7, bl4, bl3));
        int n4 = this.tabPane.getSelectedIndex();
        ((JRSUIState)this.painter.state).set(this.getSegmentTrailingSeparator(n2, n4, bl3));
        ((JRSUIState)this.painter.state).set(this.getSegmentLeadingSeparator(n2, n4, bl3));
        ((JRSUIState)this.painter.state).set(this.tabPane.hasFocus() && bl ? JRSUIConstants.Focused.YES : JRSUIConstants.Focused.NO);
        this.painter.paint(graphics, this.tabPane, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (AquaTabbedPaneUI.isScrollTabIndex(n2)) {
            return;
        }
        Color color = this.tabPane.getBackgroundAt(n2);
        if (color == null || color instanceof UIResource) {
            return;
        }
        if (!(bl3 || n != 1 && n != 3)) {
            boolean bl10 = bl4;
            bl4 = bl7;
            bl7 = bl10;
        }
        this.fillTabWithBackground(graphics, rectangle, n, bl7, bl4, color);
    }

    protected JRSUIConstants.Direction getDirection() {
        switch (this.tabPane.getTabPlacement()) {
            case 3: {
                return JRSUIConstants.Direction.SOUTH;
            }
            case 2: {
                return JRSUIConstants.Direction.WEST;
            }
            case 4: {
                return JRSUIConstants.Direction.EAST;
            }
        }
        return JRSUIConstants.Direction.NORTH;
    }

    protected static JRSUIConstants.SegmentPosition getSegmentPosition(boolean bl, boolean bl2, boolean bl3) {
        if (bl && bl2) {
            return JRSUIConstants.SegmentPosition.ONLY;
        }
        if (bl) {
            return bl3 ? JRSUIConstants.SegmentPosition.FIRST : JRSUIConstants.SegmentPosition.LAST;
        }
        if (bl2) {
            return bl3 ? JRSUIConstants.SegmentPosition.LAST : JRSUIConstants.SegmentPosition.FIRST;
        }
        return JRSUIConstants.SegmentPosition.MIDDLE;
    }

    protected JRSUIConstants.SegmentTrailingSeparator getSegmentTrailingSeparator(int n, int n2, boolean bl) {
        return JRSUIConstants.SegmentTrailingSeparator.YES;
    }

    protected JRSUIConstants.SegmentLeadingSeparator getSegmentLeadingSeparator(int n, int n2, boolean bl) {
        return JRSUIConstants.SegmentLeadingSeparator.NO;
    }

    protected boolean isTabBeforeSelectedTab(int n, int n2, boolean bl) {
        if (n == -2 && this.visibleTabState.getIndex(0) == n2) {
            return true;
        }
        int n3 = bl ? n2 - 1 : n2 + 1;
        return n == n3;
    }

    protected JRSUIConstants.State getState(int n, boolean bl, boolean bl2) {
        if (!bl) {
            return JRSUIConstants.State.INACTIVE;
        }
        if (!this.tabPane.isEnabled()) {
            return JRSUIConstants.State.DISABLED;
        }
        if (JRSUIUtils.TabbedPane.useLegacyTabs()) {
            if (bl2) {
                return JRSUIConstants.State.PRESSED;
            }
            if (this.pressedTab == n) {
                return JRSUIConstants.State.INACTIVE;
            }
        } else {
            if (bl2) {
                return JRSUIConstants.State.ACTIVE;
            }
            if (this.pressedTab == n) {
                return JRSUIConstants.State.PRESSED;
            }
        }
        return JRSUIConstants.State.ACTIVE;
    }

    protected static AlterRects getAlterationFor(int n) {
        if (alterRects[n] != null) {
            return alterRects[n];
        }
        switch (n) {
            case 2: {
                AquaTabbedPaneUI.alterRects[2] = new AlterRects(2, 0, -4, 1).start(0, 0, 0, -4).end(0, 3, 0, -3);
                return AquaTabbedPaneUI.alterRects[2];
            }
            case 4: {
                AquaTabbedPaneUI.alterRects[4] = new AlterRects(1, 0, -4, 1).start(0, 0, 0, -4).end(0, 3, 0, -3);
                return AquaTabbedPaneUI.alterRects[4];
            }
            case 3: {
                AquaTabbedPaneUI.alterRects[3] = new AlterRects(0, 1, 0, -4).start(3, 0, -3, 0).end(0, 0, -3, 0);
                return AquaTabbedPaneUI.alterRects[3];
            }
        }
        AquaTabbedPaneUI.alterRects[1] = new AlterRects(0, 2, 0, -4).start(3, 0, -3, 0).end(0, 0, -3, 0);
        return AquaTabbedPaneUI.alterRects[1];
    }

    protected void fillTabWithBackground(Graphics graphics, Rectangle rectangle, int n, boolean bl, boolean bl2, Color color) {
        Rectangle rectangle2 = new Rectangle(rectangle);
        AlterRects alterRects = AquaTabbedPaneUI.getAlterationFor(n);
        AlterRects.alter(rectangle2, alterRects.standard);
        if (bl) {
            AlterRects.alter(rectangle2, alterRects.first);
        }
        if (bl2) {
            AlterRects.alter(rectangle2, alterRects.last);
        }
        graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)((double)color.getAlpha() * 0.25)));
        graphics.fillRoundRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, 3, 1);
    }

    @Override
    protected Insets getContentBorderInsets(int n) {
        Insets insets = this.getContentDrawingInsets(n);
        AquaTabbedPaneUI.rotateInsets(this.contentBorderInsets, this.currentContentBorderInsets, n);
        this.currentContentBorderInsets.left += insets.left;
        this.currentContentBorderInsets.right += insets.right;
        this.currentContentBorderInsets.top += insets.top;
        this.currentContentBorderInsets.bottom += insets.bottom;
        return this.currentContentBorderInsets;
    }

    protected static void rotateInsets(Insets insets, Insets insets2, int n) {
        switch (n) {
            case 2: {
                insets2.top = insets.left;
                insets2.left = insets.top;
                insets2.bottom = insets.right;
                insets2.right = insets.bottom;
                break;
            }
            case 3: {
                insets2.top = insets.bottom;
                insets2.left = insets.left;
                insets2.bottom = insets.top;
                insets2.right = insets.right;
                break;
            }
            case 4: {
                insets2.top = insets.right;
                insets2.left = insets.bottom;
                insets2.bottom = insets.left;
                insets2.right = insets.top;
                break;
            }
            default: {
                insets2.top = insets.top;
                insets2.left = insets.left;
                insets2.bottom = insets.bottom;
                insets2.right = insets.right;
            }
        }
    }

    protected Insets getContentDrawingInsets(int n) {
        AquaTabbedPaneUI.rotateInsets(this.contentDrawingInsets, this.currentContentDrawingInsets, n);
        return this.currentContentDrawingInsets;
    }

    @Override
    protected Icon getIconForTab(int n) {
        final Icon icon = super.getIconForTab(n);
        if (icon == null) {
            return null;
        }
        int n2 = icon.getIconHeight();
        if (n2 <= 16) {
            return icon;
        }
        float f = 16.0f / (float)n2;
        int n3 = icon.getIconWidth();
        return new AquaIcon.CachingScalingIcon((int)((float)n3 * f), 16){

            @Override
            Image createImage() {
                return AquaIcon.getImageForIcon(icon);
            }
        };
    }

    @Override
    protected void paintContentBorder(Graphics graphics, int n, int n2) {
        int n3 = this.tabPane.getWidth();
        int n4 = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int n5 = insets.left;
        int n6 = insets.top;
        int n7 = n3 - insets.right - insets.left;
        int n8 = n4 - insets.top - insets.bottom;
        switch (n) {
            case 1: {
                n6 += 9;
                n8 -= 9;
                break;
            }
            case 3: {
                n8 -= 9;
                break;
            }
            case 2: {
                n5 += 9;
                n7 -= 9;
                break;
            }
            case 4: {
                n7 -= 9;
            }
        }
        if (this.tabPane.isOpaque()) {
            graphics.setColor(this.tabPane.getBackground());
            graphics.fillRect(0, 0, n3, n4);
        }
        AquaGroupBorder.getTabbedPaneGroupBorder().paintBorder(this.tabPane, graphics, n5, n6, n7, n8);
    }

    protected void repaintContentBorderEdge() {
        int n = this.tabPane.getWidth();
        int n2 = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int n3 = this.tabPane.getTabPlacement();
        Insets insets2 = this.getContentBorderInsets(n3);
        int n4 = insets.left;
        int n5 = insets.top;
        int n6 = n - insets.right - insets.left;
        int n7 = n2 - insets.top - insets.bottom;
        switch (n3) {
            case 2: {
                n4 += this.calculateTabAreaWidth(n3, this.runCount, this.maxTabWidth);
                n6 = insets2.left;
                break;
            }
            case 4: {
                n6 = insets2.right;
                break;
            }
            case 3: {
                n7 = insets2.bottom;
                break;
            }
            default: {
                n5 += this.calculateTabAreaHeight(n3, this.runCount, this.maxTabHeight);
                n7 = insets2.top;
            }
        }
        this.tabPane.repaint(n4, n5, n6, n7);
    }

    public boolean isTabVisible(int n) {
        if (n == -1 || n == -2) {
            return true;
        }
        for (int i = 0; i < this.visibleTabState.getTotal(); ++i) {
            if (this.visibleTabState.getIndex(i) != n) continue;
            return true;
        }
        return false;
    }

    @Override
    public Rectangle getTabBounds(JTabbedPane jTabbedPane, int n) {
        if (this.visibleTabState.needsScrollTabs() && (this.visibleTabState.isBefore(n) || this.visibleTabState.isAfter(n))) {
            return null;
        }
        return super.getTabBounds(jTabbedPane, n);
    }

    @Override
    public int tabForCoordinate(JTabbedPane jTabbedPane, int n, int n2) {
        this.ensureCurrentLayout();
        Point point = new Point(n, n2);
        if (this.visibleTabState.needsScrollTabs()) {
            for (int i = 0; i < this.visibleTabState.getTotal(); ++i) {
                int n3 = this.visibleTabState.getIndex(i);
                if (!this.rects[n3].contains(point.x, point.y)) continue;
                return n3;
            }
            if (this.visibleTabState.getRightScrollTabRect().contains(point.x, point.y)) {
                return -1;
            }
        } else {
            int n4 = this.tabPane.getTabCount();
            for (int i = 0; i < n4; ++i) {
                if (!this.rects[i].contains(point.x, point.y)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    protected Insets getTabInsets(int n, int n2) {
        switch (n) {
            case 2: {
                return UIManager.getInsets("TabbedPane.leftTabInsets");
            }
            case 4: {
                return UIManager.getInsets("TabbedPane.rightTabInsets");
            }
        }
        return this.tabInsets;
    }

    @Override
    protected int calculateTabHeight(int n, int n2, int n3) {
        int n4 = super.calculateTabHeight(n, n2, n3);
        if (n4 <= 20) {
            return 20;
        }
        return 23;
    }

    @Override
    protected boolean shouldRotateTabRuns(int n) {
        return false;
    }

    @Override
    protected ChangeListener createChangeListener() {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!AquaTabbedPaneUI.this.isTabVisible(AquaTabbedPaneUI.this.tabPane.getSelectedIndex())) {
                    AquaTabbedPaneUI.this.popupSelectionChanged = true;
                }
                AquaTabbedPaneUI.this.tabPane.revalidate();
                AquaTabbedPaneUI.this.tabPane.repaint();
            }
        };
    }

    protected class AquaTruncatingTabbedPaneLayout
    extends AquaTabbedPaneCopyFromBasicUI.TabbedPaneLayout {
        protected AquaTruncatingTabbedPaneLayout() {
            super(AquaTabbedPaneUI.this);
        }

        @Override
        protected int preferredTabAreaWidth(int n, int n2) {
            if (n == 2 || n == 4) {
                return super.preferredTabAreaHeight(n, n2);
            }
            return super.preferredTabAreaWidth(n, n2);
        }

        @Override
        protected int preferredTabAreaHeight(int n, int n2) {
            if (n == 2 || n == 4) {
                return super.preferredTabAreaWidth(n, n2);
            }
            return super.preferredTabAreaHeight(n, n2);
        }

        @Override
        protected void calculateTabRects(int n, int n2) {
            if (n2 <= 0) {
                return;
            }
            this.superCalculateTabRects(n, n2);
            if (AquaTabbedPaneUI.this.rects.length <= 0) {
                return;
            }
            AquaTabbedPaneUI.this.visibleTabState.alignRectsRunFor(AquaTabbedPaneUI.this.rects, AquaTabbedPaneUI.this.tabPane.getSize(), n, AquaUtils.isLeftToRight(AquaTabbedPaneUI.this.tabPane));
        }

        @Override
        protected void padTabRun(int n, int n2, int n3, int n4) {
            if (n == 1 || n == 3) {
                super.padTabRun(n, n2, n3, n4);
                return;
            }
            Rectangle rectangle = AquaTabbedPaneUI.this.rects[n3];
            int n5 = rectangle.y + rectangle.height - AquaTabbedPaneUI.this.rects[n2].y;
            int n6 = n4 - (rectangle.y + rectangle.height);
            float f = (float)n6 / (float)n5;
            for (int i = n2; i <= n3; ++i) {
                Rectangle rectangle2 = AquaTabbedPaneUI.this.rects[i];
                if (i > n2) {
                    rectangle2.y = AquaTabbedPaneUI.this.rects[i - 1].y + AquaTabbedPaneUI.this.rects[i - 1].height;
                }
                rectangle2.height += Math.round((float)rectangle2.height * f);
            }
            rectangle.height = n4 - rectangle.y;
        }

        protected synchronized void superCalculateTabRects(int n, int n2) {
            int n3;
            int n4;
            int n5;
            int n6;
            Dimension dimension = AquaTabbedPaneUI.this.tabPane.getSize();
            Insets insets = AquaTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = AquaTabbedPaneUI.this.getTabAreaInsets(n);
            switch (n) {
                case 2: {
                    AquaTabbedPaneUI.this.maxTabWidth = AquaTabbedPaneUI.this.calculateMaxTabHeight(n);
                    n6 = insets.left + insets2.left;
                    n5 = insets.top + insets2.top;
                    n4 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 4: {
                    AquaTabbedPaneUI.this.maxTabWidth = AquaTabbedPaneUI.this.calculateMaxTabHeight(n);
                    n6 = dimension.width - insets.right - insets2.right - AquaTabbedPaneUI.this.maxTabWidth - 1;
                    n5 = insets.top + insets2.top;
                    n4 = dimension.height - (insets.bottom + insets2.bottom);
                    break;
                }
                case 3: {
                    AquaTabbedPaneUI.this.maxTabHeight = AquaTabbedPaneUI.this.calculateMaxTabHeight(n);
                    n6 = insets.left + insets2.left;
                    n5 = dimension.height - insets.bottom - insets2.bottom - AquaTabbedPaneUI.this.maxTabHeight;
                    n4 = dimension.width - (insets.right + insets2.right);
                    break;
                }
                default: {
                    AquaTabbedPaneUI.this.maxTabHeight = AquaTabbedPaneUI.this.calculateMaxTabHeight(n);
                    n6 = insets.left + insets2.left;
                    n5 = insets.top + insets2.top;
                    n4 = dimension.width - (insets.right + insets2.right);
                }
            }
            AquaTabbedPaneUI.this.tabRunOverlay = AquaTabbedPaneUI.this.getTabRunOverlay(n);
            AquaTabbedPaneUI.this.runCount = 0;
            AquaTabbedPaneUI.this.selectedRun = 0;
            if (n2 == 0) {
                return;
            }
            FontMetrics fontMetrics = AquaTabbedPaneUI.this.getFontMetrics();
            boolean bl = n == 2 || n == 4;
            int n7 = AquaTabbedPaneUI.this.tabPane.getSelectedIndex();
            AquaTabbedPaneUI.this.visibleTabState.setNeedsScrollers(false);
            for (n3 = 0; n3 < n2; ++n3) {
                Rectangle rectangle = AquaTabbedPaneUI.this.rects[n3];
                if (bl) {
                    this.calculateVerticalTabRunRect(rectangle, fontMetrics, n, n4, n3, n6, n5);
                    if (rectangle.y + rectangle.height <= n4) continue;
                    AquaTabbedPaneUI.this.visibleTabState.setNeedsScrollers(true);
                    continue;
                }
                this.calculateHorizontalTabRunRect(rectangle, fontMetrics, n, n4, n3, n6, n5);
                if (rectangle.x + rectangle.width <= n4) continue;
                AquaTabbedPaneUI.this.visibleTabState.setNeedsScrollers(true);
            }
            AquaTabbedPaneUI.this.visibleTabState.relayoutForScrolling(AquaTabbedPaneUI.this.rects, n6, n5, n4, n7, bl, n2, AquaUtils.isLeftToRight(AquaTabbedPaneUI.this.tabPane));
            if (!AquaUtils.isLeftToRight(AquaTabbedPaneUI.this.tabPane) && !bl) {
                n3 = dimension.width - (insets.right + insets2.right);
                for (int i = 0; i < n2; ++i) {
                    AquaTabbedPaneUI.this.rects[i].x = n3 - AquaTabbedPaneUI.this.rects[i].x - AquaTabbedPaneUI.this.rects[i].width;
                }
            }
        }

        private void calculateHorizontalTabRunRect(Rectangle rectangle, FontMetrics fontMetrics, int n, int n2, int n3, int n4, int n5) {
            if (n3 > 0) {
                rectangle.x = AquaTabbedPaneUI.this.rects[n3 - 1].x + AquaTabbedPaneUI.this.rects[n3 - 1].width;
            } else {
                AquaTabbedPaneUI.this.tabRuns[0] = 0;
                AquaTabbedPaneUI.this.runCount = 1;
                AquaTabbedPaneUI.this.maxTabWidth = 0;
                rectangle.x = n4;
            }
            rectangle.width = AquaTabbedPaneUI.this.calculateTabWidth(n, n3, fontMetrics);
            AquaTabbedPaneUI.this.maxTabWidth = Math.max(AquaTabbedPaneUI.this.maxTabWidth, rectangle.width);
            rectangle.y = n5;
            rectangle.height = AquaTabbedPaneUI.this.maxTabHeight;
        }

        private void calculateVerticalTabRunRect(Rectangle rectangle, FontMetrics fontMetrics, int n, int n2, int n3, int n4, int n5) {
            if (n3 > 0) {
                rectangle.y = AquaTabbedPaneUI.this.rects[n3 - 1].y + AquaTabbedPaneUI.this.rects[n3 - 1].height;
            } else {
                AquaTabbedPaneUI.this.tabRuns[0] = 0;
                AquaTabbedPaneUI.this.runCount = 1;
                AquaTabbedPaneUI.this.maxTabHeight = 0;
                rectangle.y = n5;
            }
            rectangle.height = AquaTabbedPaneUI.this.calculateTabWidth(n, n3, fontMetrics);
            AquaTabbedPaneUI.this.maxTabHeight = Math.max(AquaTabbedPaneUI.this.maxTabHeight, rectangle.height);
            rectangle.x = n4;
            rectangle.width = AquaTabbedPaneUI.this.maxTabWidth;
        }

        @Override
        protected void layoutTabComponents() {
            Container container = this.getTabContainer();
            if (container == null) {
                return;
            }
            int n = AquaTabbedPaneUI.this.tabPane.getTabPlacement();
            Rectangle rectangle = new Rectangle();
            Point point = new Point(-container.getX(), -container.getY());
            for (int i = 0; i < AquaTabbedPaneUI.this.tabPane.getTabCount(); ++i) {
                boolean bl;
                Component component = AquaTabbedPaneUI.this.getTabComponentAt(i);
                if (component == null) continue;
                AquaTabbedPaneUI.this.getTabBounds(i, rectangle);
                Insets insets = AquaTabbedPaneUI.this.getTabInsets(AquaTabbedPaneUI.this.tabPane.getTabPlacement(), i);
                boolean bl2 = bl = i == AquaTabbedPaneUI.this.tabPane.getSelectedIndex();
                if (n == 1 || n == 3) {
                    rectangle.x += insets.left + point.x + AquaTabbedPaneUI.this.getTabLabelShiftX(n, i, bl);
                    rectangle.y += insets.top + point.y + AquaTabbedPaneUI.this.getTabLabelShiftY(n, i, bl) + 1;
                    rectangle.width -= insets.left + insets.right;
                    rectangle.height -= insets.top + insets.bottom - 1;
                } else {
                    rectangle.x = rectangle.x + (insets.top + point.x + AquaTabbedPaneUI.this.getTabLabelShiftY(n, i, bl) + (n == 2 ? 2 : 1));
                    rectangle.y += insets.left + point.y + AquaTabbedPaneUI.this.getTabLabelShiftX(n, i, bl);
                    rectangle.width -= insets.top + insets.bottom - 1;
                    rectangle.height -= insets.left + insets.right;
                }
                component.setBounds(rectangle);
            }
        }
    }

    public class MouseHandler
    extends MouseInputAdapter
    implements ActionListener {
        protected int trackingTab = -3;
        protected Timer popupTimer = new Timer(500, this);

        public MouseHandler() {
            this.popupTimer.setRepeats(false);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)mouseEvent.getSource();
            if (!jTabbedPane.isEnabled()) {
                this.trackingTab = -3;
                return;
            }
            Point point = mouseEvent.getPoint();
            this.trackingTab = this.getCurrentTab(jTabbedPane, point);
            if (this.trackingTab == -3 || !AquaTabbedPaneUI.this.shouldRepaintSelectedTabOnMouseDown() && this.trackingTab == jTabbedPane.getSelectedIndex()) {
                this.trackingTab = -3;
                return;
            }
            if (this.trackingTab < 0 && this.trackingTab > -3) {
                this.popupTimer.start();
            }
            AquaTabbedPaneUI.this.pressedTab = this.trackingTab;
            this.repaint(jTabbedPane, AquaTabbedPaneUI.this.pressedTab);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.trackingTab < -2) {
                return;
            }
            JTabbedPane jTabbedPane = (JTabbedPane)mouseEvent.getSource();
            int n = this.getCurrentTab(jTabbedPane, mouseEvent.getPoint());
            AquaTabbedPaneUI.this.pressedTab = n != this.trackingTab ? -3 : this.trackingTab;
            if (this.trackingTab < 0 && this.trackingTab > -3) {
                this.popupTimer.start();
            }
            this.repaint(jTabbedPane, this.trackingTab);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.trackingTab < -2) {
                return;
            }
            this.popupTimer.stop();
            JTabbedPane jTabbedPane = (JTabbedPane)mouseEvent.getSource();
            Point point = mouseEvent.getPoint();
            int n = this.getCurrentTab(jTabbedPane, point);
            if (this.trackingTab == -1 && n == -1) {
                jTabbedPane.setSelectedIndex(jTabbedPane.getSelectedIndex() + 1);
            }
            if (this.trackingTab == -2 && n == -2) {
                jTabbedPane.setSelectedIndex(jTabbedPane.getSelectedIndex() - 1);
            }
            if (this.trackingTab >= 0 && n == this.trackingTab) {
                jTabbedPane.setSelectedIndex(this.trackingTab);
            }
            this.repaint(jTabbedPane, this.trackingTab);
            AquaTabbedPaneUI.this.pressedTab = -3;
            this.trackingTab = -3;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.trackingTab != AquaTabbedPaneUI.this.pressedTab) {
                return;
            }
            if (this.trackingTab == -1) {
                this.showFullPopup(false);
                this.trackingTab = -3;
            }
            if (this.trackingTab == -2) {
                this.showFullPopup(true);
                this.trackingTab = -3;
            }
        }

        int getCurrentTab(JTabbedPane jTabbedPane, Point point) {
            int n = AquaTabbedPaneUI.this.tabForCoordinate(jTabbedPane, point.x, point.y);
            if (n >= 0 && jTabbedPane.isEnabledAt(n)) {
                return n;
            }
            if (AquaTabbedPaneUI.this.visibleTabState.needsLeftScrollTab() && AquaTabbedPaneUI.this.visibleTabState.getLeftScrollTabRect().contains(point)) {
                return -2;
            }
            if (AquaTabbedPaneUI.this.visibleTabState.needsRightScrollTab() && AquaTabbedPaneUI.this.visibleTabState.getRightScrollTabRect().contains(point)) {
                return -1;
            }
            return -3;
        }

        void repaint(JTabbedPane jTabbedPane, int n) {
            switch (n) {
                case -1: {
                    jTabbedPane.repaint(AquaTabbedPaneUI.this.visibleTabState.getRightScrollTabRect());
                    return;
                }
                case -2: {
                    jTabbedPane.repaint(AquaTabbedPaneUI.this.visibleTabState.getLeftScrollTabRect());
                    return;
                }
            }
            if (this.trackingTab >= 0) {
                jTabbedPane.repaint(AquaTabbedPaneUI.this.rects[this.trackingTab]);
            }
        }

        void showFullPopup(boolean bl) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            for (int i = 0; i < AquaTabbedPaneUI.this.tabPane.getTabCount(); ++i) {
                if (!(bl ? AquaTabbedPaneUI.this.visibleTabState.isBefore(i) : AquaTabbedPaneUI.this.visibleTabState.isAfter(i))) continue;
                jPopupMenu.add(this.createMenuItem(i));
            }
            if (bl) {
                Rectangle rectangle = AquaTabbedPaneUI.this.visibleTabState.getLeftScrollTabRect();
                Dimension dimension = jPopupMenu.getPreferredSize();
                jPopupMenu.show(AquaTabbedPaneUI.this.tabPane, rectangle.x - dimension.width, rectangle.y + 7);
            } else {
                Rectangle rectangle = AquaTabbedPaneUI.this.visibleTabState.getRightScrollTabRect();
                jPopupMenu.show(AquaTabbedPaneUI.this.tabPane, rectangle.x + rectangle.width, rectangle.y + 7);
            }
            jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    AquaTabbedPaneUI.this.pressedTab = -3;
                    AquaTabbedPaneUI.this.tabPane.repaint(AquaTabbedPaneUI.this.visibleTabState.getLeftScrollTabRect());
                    AquaTabbedPaneUI.this.tabPane.repaint(AquaTabbedPaneUI.this.visibleTabState.getRightScrollTabRect());
                }
            });
        }

        JMenuItem createMenuItem(int n) {
            final Component component = AquaTabbedPaneUI.this.getTabComponentAt(n);
            JMenuItem jMenuItem = component == null ? new JMenuItem(AquaTabbedPaneUI.this.tabPane.getTitleAt(n), AquaTabbedPaneUI.this.tabPane.getIconAt(n)) : new JMenuItem(){

                @Override
                public void paintComponent(Graphics graphics) {
                    super.paintComponent(graphics);
                    Dimension dimension = component.getSize();
                    component.setSize(this.getSize());
                    component.validate();
                    component.paint(graphics);
                    component.setSize(dimension);
                }

                @Override
                public Dimension getPreferredSize() {
                    return component.getPreferredSize();
                }
            };
            Color color = AquaTabbedPaneUI.this.tabPane.getBackgroundAt(n);
            if (!(color instanceof UIResource)) {
                jMenuItem.setBackground(color);
            }
            jMenuItem.setForeground(AquaTabbedPaneUI.this.tabPane.getForegroundAt(n));
            if (!AquaTabbedPaneUI.this.tabPane.isEnabledAt(n)) {
                jMenuItem.setEnabled(false);
            }
            final int n2 = n;
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    boolean bl = AquaTabbedPaneUI.this.isTabVisible(n2);
                    AquaTabbedPaneUI.this.tabPane.setSelectedIndex(n2);
                    if (!bl) {
                        AquaTabbedPaneUI.this.popupSelectionChanged = true;
                        AquaTabbedPaneUI.this.tabPane.invalidate();
                        AquaTabbedPaneUI.this.tabPane.repaint();
                    }
                }
            });
            return jMenuItem;
        }
    }

    protected class FocusHandler
    extends FocusAdapter {
        Rectangle sWorkingRect = new Rectangle();

        protected FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (this.isDefaultFocusReceiver(AquaTabbedPaneUI.this.tabPane) && !AquaTabbedPaneUI.this.hasAvoidedFirstFocus) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                AquaTabbedPaneUI.this.hasAvoidedFirstFocus = true;
            }
            this.adjustPaintingRectForFocusRing(focusEvent);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.adjustPaintingRectForFocusRing(focusEvent);
        }

        void adjustPaintingRectForFocusRing(FocusEvent focusEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)focusEvent.getSource();
            int n = jTabbedPane.getTabCount();
            int n2 = jTabbedPane.getSelectedIndex();
            if (n2 != -1 && n > 0 && n == AquaTabbedPaneUI.this.rects.length) {
                this.sWorkingRect.setBounds(AquaTabbedPaneUI.this.rects[n2]);
                this.sWorkingRect.grow(4, 4);
                jTabbedPane.repaint(this.sWorkingRect);
            }
        }

        boolean isDefaultFocusReceiver(JComponent jComponent) {
            if (AquaTabbedPaneUI.this.isDefaultFocusReceiver == null) {
                Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalPolicy().getDefaultComponent(this.getTopLevelFocusCycleRootAncestor(jComponent));
                AquaTabbedPaneUI.this.isDefaultFocusReceiver = new Boolean(component != null && component.equals(jComponent));
            }
            return AquaTabbedPaneUI.this.isDefaultFocusReceiver;
        }

        Container getTopLevelFocusCycleRootAncestor(Container container) {
            Container container2;
            while ((container2 = container.getFocusCycleRootAncestor()) != null) {
                container = container2;
            }
            return container;
        }
    }

    protected class TabbedPanePropertyChangeHandler
    extends AquaTabbedPaneCopyFromBasicUI.PropertyChangeHandler {
        protected TabbedPanePropertyChangeHandler() {
            super(AquaTabbedPaneUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (!"Frame.active".equals(string)) {
                super.propertyChange(propertyChangeEvent);
                return;
            }
            JTabbedPane jTabbedPane = (JTabbedPane)propertyChangeEvent.getSource();
            jTabbedPane.repaint();
            int n = AquaTabbedPaneUI.this.tabPane.getSelectedIndex();
            Rectangle[] rectangleArray = AquaTabbedPaneUI.this.rects;
            if (n >= 0 && n < rectangleArray.length) {
                jTabbedPane.repaint(rectangleArray[n]);
            }
            AquaTabbedPaneUI.this.repaintContentBorderEdge();
        }
    }

    static class AlterRects {
        Rectangle standard;
        Rectangle first;
        Rectangle last;

        AlterRects(int n, int n2, int n3, int n4) {
            this.standard = new Rectangle(n, n2, n3, n4);
        }

        AlterRects start(int n, int n2, int n3, int n4) {
            this.first = new Rectangle(n, n2, n3, n4);
            return this;
        }

        AlterRects end(int n, int n2, int n3, int n4) {
            this.last = new Rectangle(n, n2, n3, n4);
            return this;
        }

        static Rectangle alter(Rectangle rectangle, Rectangle rectangle2) {
            rectangle.x += rectangle2.x;
            rectangle.y += rectangle2.y;
            rectangle.width += rectangle2.width;
            rectangle.height += rectangle2.height;
            return rectangle;
        }
    }
}

