/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels;

import com.agateau.pixelwheels.gamesetup.Difficulty;
import com.agateau.pixelwheels.map.Championship;
import com.agateau.pixelwheels.map.Track;
import com.agateau.pixelwheels.stats.GameStats;
import com.agateau.pixelwheels.stats.TrackStats;
import com.badlogic.gdx.utils.Array;
import java.util.ArrayList;

class GameStatsSetup {
    GameStatsSetup() {
    }

    static void loadDefaultRecords(GameStats gameStats, Array<Championship> championships) {
        for (Championship championship : championships) {
            for (Track track : championship.getTracks()) {
                for (Difficulty difficulty : Difficulty.values()) {
                    TrackStats trackStats = gameStats.getTrackStats(difficulty, track);
                    GameStatsSetup.loadDefaultRecordsForTrack(trackStats, difficulty, track);
                }
            }
        }
    }

    private static void loadDefaultRecordsForTrack(TrackStats trackStats, Difficulty difficulty, Track track) {
        for (TrackStats.ResultType resultType : TrackStats.ResultType.values()) {
            ArrayList<Float> defaultRecords = track.getDefaultTrackRecords(difficulty, resultType);
            for (float record : defaultRecords) {
                trackStats.addResult(resultType, "CPU", record);
            }
        }
    }
}

