/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels;

import com.agateau.pixelwheels.Language;
import com.agateau.ui.FontSet;
import com.agateau.utils.Assert;
import com.agateau.utils.FileUtils;
import com.agateau.utils.log.NLog;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.XmlReader;
import java.util.HashMap;
import java.util.Locale;

public class Languages {
    public static final String DEFAULT_ID = "en";
    private final HashMap<String, FontSet> mFontSets = new HashMap();
    private final Array<Language> mLanguages = new Array();

    public Languages(FileHandle handle) {
        if (!handle.exists()) {
            throw new RuntimeException("No such file " + handle.name());
        }
        XmlReader.Element root = FileUtils.parseXml(handle);
        for (XmlReader.Element element : root.getChildrenByName("FontSet")) {
            this.loadFontSet(element);
        }
        for (XmlReader.Element element : root.getChildrenByName("Language")) {
            this.loadLanguage(element);
        }
    }

    public String findBestLanguageId() {
        String lang = Locale.getDefault().getLanguage();
        String langAndCountry = lang + "_" + Locale.getDefault().getCountry();
        if (this.findLanguage(langAndCountry) != null) {
            return langAndCountry;
        }
        if (this.findLanguage(lang) != null) {
            return lang;
        }
        NLog.i("Neither %s nor %s are supported languages", langAndCountry, lang);
        return DEFAULT_ID;
    }

    public Language getLanguage(String languageId) {
        Language language = this.findLanguage(languageId);
        if (language != null) {
            return language;
        }
        NLog.e("No language with id %s", languageId);
        language = this.findLanguage(DEFAULT_ID);
        Assert.check(language != null, "Could not find language with id en", new Object[0]);
        return language;
    }

    public FontSet getFontSet(String languageId) {
        return this.getLanguage((String)languageId).fontSet;
    }

    public Array<Language> getAll() {
        return this.mLanguages;
    }

    private void loadFontSet(XmlReader.Element element) {
        FontSet fontSet = new FontSet();
        fontSet.defaultFontName = element.getAttribute("defaultFontName");
        fontSet.defaultBoldFontName = element.getAttribute("defaultBoldFontName");
        fontSet.defaultFontSize = element.getIntAttribute("defaultFontSize");
        fontSet.titleFontName = element.getAttribute("titleFontName");
        fontSet.titleFontSize = element.getIntAttribute("titleFontSize");
        fontSet.hudFontName = element.getAttribute("hudFontName");
        this.mFontSets.put(element.getAttribute("id"), fontSet);
    }

    private void loadLanguage(XmlReader.Element element) {
        String fontSetId = element.getAttribute("fontSet");
        FontSet fontSet = this.mFontSets.get(fontSetId);
        Assert.check(fontSet != null, "No fontset with id " + fontSetId, new Object[0]);
        Language language = new Language(element.getAttribute("id"), element.getAttribute("name"), fontSet);
        this.mLanguages.add(language);
    }

    private Language findLanguage(String languageId) {
        for (Language language : this.mLanguages) {
            if (!language.id.equals(languageId)) continue;
            return language;
        }
        return null;
    }
}

