/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.Constants;
import com.agateau.pixelwheels.GameConfig;
import com.agateau.pixelwheels.GamePlay;
import com.agateau.pixelwheels.GameStatsSetup;
import com.agateau.pixelwheels.LogExporter;
import com.agateau.pixelwheels.RewardManagerSetup;
import com.agateau.pixelwheels.debug.Debug;
import com.agateau.pixelwheels.gamesetup.ChampionshipGameInfo;
import com.agateau.pixelwheels.gamesetup.ChampionshipMaestro;
import com.agateau.pixelwheels.gamesetup.Maestro;
import com.agateau.pixelwheels.gamesetup.QuickRaceMaestro;
import com.agateau.pixelwheels.rewards.RewardManager;
import com.agateau.pixelwheels.screens.MainMenuScreen;
import com.agateau.pixelwheels.screens.PwStageScreen;
import com.agateau.pixelwheels.screens.UnlockedRewardScreen;
import com.agateau.pixelwheels.sound.AudioManager;
import com.agateau.pixelwheels.sound.DefaultAudioManager;
import com.agateau.pixelwheels.sound.SoundSettings;
import com.agateau.pixelwheels.stats.GameStats;
import com.agateau.pixelwheels.stats.GameStatsImpl;
import com.agateau.pixelwheels.stats.JsonGameStatsImplIO;
import com.agateau.ui.MouseCursorManager;
import com.agateau.ui.ScreenStack;
import com.agateau.ui.UiInputMapper;
import com.agateau.ui.VirtualKey;
import com.agateau.utils.Assert;
import com.agateau.utils.FileUtils;
import com.agateau.utils.Introspector;
import com.agateau.utils.PlatformUtils;
import com.agateau.utils.ScreenshotCreator;
import com.agateau.utils.log.NLog;
import com.agateau.utils.log.NLogGdxApplicationLogger;
import com.badlogic.gdx.Game;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.physics.box2d.Box2D;

public class PwGame
extends Game
implements GameConfig.ChangeListener {
    private Assets mAssets;
    private final ScreenStack mScreenStack = new ScreenStack(this);
    private Maestro mMaestro;
    private GameConfig mGameConfig;
    private AudioManager mAudioManager;
    private Introspector mGamePlayIntrospector;
    private Introspector mDebugIntrospector;
    private Introspector mSoundSettingsIntrospector;
    private GameStatsImpl mGameStats;
    private RewardManager mRewardManager;
    private GameStatsImpl.IO mNormalGameStatsIO;
    private final GameStatsImpl.IO mNoSaveGameStatsIO = new GameStatsImpl.IO(){

        @Override
        public void load(GameStatsImpl gameStats) {
            PwGame.this.mNormalGameStatsIO.load(gameStats);
        }

        @Override
        public void save(GameStatsImpl gameStats) {
        }
    };
    private LogExporter mLogExporter;
    private String mExtraOsInformation = "";

    public Assets getAssets() {
        return this.mAssets;
    }

    public AudioManager getAudioManager() {
        return this.mAudioManager;
    }

    public RewardManager getRewardManager() {
        return this.mRewardManager;
    }

    private static Introspector createIntrospector(Object instance, String fileName) {
        FileHandle handle = FileUtils.getUserWritableFile(fileName);
        Introspector introspector = Introspector.fromInstance(instance, handle);
        introspector.load();
        return introspector;
    }

    public LogExporter getLogExporter() {
        return this.mLogExporter;
    }

    public void setLogExporter(LogExporter logExporter) {
        this.mLogExporter = logExporter;
    }

    @Override
    public void create() {
        NLogGdxApplicationLogger.install();
        this.logStartup();
        this.setupExtraAssetsDir();
        this.mGamePlayIntrospector = PwGame.createIntrospector(GamePlay.instance, "gameplay.xml");
        this.mDebugIntrospector = PwGame.createIntrospector(Debug.instance, "debug.xml");
        this.mSoundSettingsIntrospector = PwGame.createIntrospector(SoundSettings.instance, "sound.xml");
        this.mGamePlayIntrospector.addListener(this::updateGameStatsIO);
        this.mAssets = new Assets();
        this.mAudioManager = new DefaultAudioManager(this.mAssets);
        this.setupCursorManager();
        this.setupConfig();
        this.setupTrackStats();
        this.setupRewardManager();
        Box2D.init();
        this.setupDisplay();
        this.showMainMenu();
    }

    private void setupExtraAssetsDir() {
        String assetsDir = System.getenv("PW_ASSETS_DIR");
        if (assetsDir != null) {
            FileUtils.setExtraAssetsDir(assetsDir);
        }
    }

    private void logStartup() {
        NLog.i("-------------------------------------------", new Object[0]);
        NLog.i("Pixel Wheels: version='%s'", "1.0.0-rc.1");
        NLog.i("Java: vendor='%s' version='%s'", System.getProperty("java.vendor"), System.getProperty("java.version"));
        NLog.i("OS: name='%s' version='%s' arch='%s'", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
        if (!this.mExtraOsInformation.isEmpty()) {
            NLog.i(this.mExtraOsInformation, new Object[0]);
        }
    }

    private void loadTranslations() {
        NLog.i("Loading translations for language '%s'", this.mGameConfig.languageId);
        this.mAssets.setLanguage(this.mGameConfig.languageId);
        if (this.mRewardManager != null) {
            this.setupRewardManager();
        }
    }

    @Override
    public void render() {
        if (UiInputMapper.getInstance().isKeyJustPressed(VirtualKey.SCREENSHOT)) {
            String path = ScreenshotCreator.saveScreenshot();
            NLog.i("Screenshot saved in %s", path);
        }
        MouseCursorManager.getInstance().act();
        super.render();
    }

    public void refreshAssets() {
        this.mAssets = new Assets();
        this.mAssets.setLanguage(this.mGameConfig.languageId);
        this.setupRewardManager();
        this.setupCursorManager();
    }

    private void setupCursorManager() {
        MouseCursorManager.getInstance().setCursorPixmap(FileUtils.assets("ui/cursor.png"));
    }

    private void setupConfig() {
        this.mGameConfig = new GameConfig();
        if (this.mGameConfig.languageId.isEmpty()) {
            this.mGameConfig.languageId = this.mAssets.languages.findBestLanguageId();
        }
        this.mGameConfig.addListener(this);
        this.onGameConfigChanged(GameConfig.ConfigGroup.OTHER);
        this.onGameConfigChanged(GameConfig.ConfigGroup.LANGUAGE);
    }

    private void setupTrackStats() {
        this.mNormalGameStatsIO = new JsonGameStatsImplIO(FileUtils.getUserWritableFile("gamestats.json"));
        this.mGameStats = new GameStatsImpl(this.getCurrentGameStatsIO());
        GameStatsSetup.loadDefaultRecords(this.mGameStats, this.mAssets.championships);
    }

    private GameStatsImpl.IO getCurrentGameStatsIO() {
        return this.mGamePlayIntrospector.hasBeenModified() ? this.mNoSaveGameStatsIO : this.mNormalGameStatsIO;
    }

    private void updateGameStatsIO() {
        this.mGameStats.setIO(this.getCurrentGameStatsIO());
    }

    private void setupRewardManager() {
        Assert.check(this.mGameStats != null, "GameStats must be instantiated first", new Object[0]);
        Assert.check(this.mAssets != null, "Assets must be instantiated first", new Object[0]);
        this.mRewardManager = new RewardManager(this.mGameStats);
        RewardManagerSetup.createChampionshipRules(this.mRewardManager, this.mAssets.championships);
        RewardManagerSetup.createVehicleRules(this.mRewardManager, this.mAssets);
        this.mRewardManager.markAllUnlockedRewardsSeen();
    }

    public void showMainMenu() {
        this.mScreenStack.clear();
        this.mAudioManager.playMusic("menu");
        PwStageScreen screen = Constants.DEBUG_SCREEN.startsWith("Unlocked") ? UnlockedRewardScreen.createDebugScreen(this) : new MainMenuScreen(this);
        this.mScreenStack.push(screen);
    }

    public void showQuickRace(int playerCount) {
        this.mMaestro = new QuickRaceMaestro(this, playerCount);
        this.mMaestro.start();
    }

    public void showChampionship(int playerCount) {
        this.mMaestro = new ChampionshipMaestro(this, playerCount);
        this.mMaestro.start();
    }

    public void replaceScreen(Screen screen) {
        this.mScreenStack.replace(screen);
    }

    public GameConfig getConfig() {
        return this.mGameConfig;
    }

    public GameStats getGameStats() {
        return this.mGameStats;
    }

    public Maestro getMaestro() {
        return this.mMaestro;
    }

    public Introspector getGamePlayIntrospector() {
        return this.mGamePlayIntrospector;
    }

    public Introspector getDebugIntrospector() {
        return this.mDebugIntrospector;
    }

    public Introspector getSoundSettingsIntrospector() {
        return this.mSoundSettingsIntrospector;
    }

    public ScreenStack getScreenStack() {
        return this.mScreenStack;
    }

    public void pushScreen(Screen screen) {
        this.mScreenStack.push(screen);
    }

    public void popScreen() {
        this.mScreenStack.pop();
    }

    private void setupDisplay() {
        this.setFullscreen(this.mGameConfig.fullscreen);
    }

    public void setFullscreen(boolean fullscreen) {
        if (!PlatformUtils.isDesktop()) {
            return;
        }
        if (fullscreen) {
            Graphics.DisplayMode mode = Gdx.graphics.getDisplayMode();
            Gdx.graphics.setFullscreenMode(mode);
        } else {
            Gdx.graphics.setWindowedMode(960, 540);
        }
    }

    public void onChampionshipFinished(ChampionshipGameInfo gameInfo) {
        this.mGameStats.onChampionshipFinished(this.mGameConfig.difficulty, gameInfo.getChampionship(), gameInfo.getBestRank());
    }

    @Override
    public void onGameConfigChanged(GameConfig.ConfigGroup group) {
        switch (group) {
            case INPUT: {
                break;
            }
            case LANGUAGE: {
                this.loadTranslations();
                break;
            }
            case OTHER: {
                this.mAudioManager.setSoundFxMuted(!this.mGameConfig.playSoundFx);
                this.mAudioManager.setMusicMuted(!this.mGameConfig.playMusic);
            }
        }
    }

    public void setExtraOsInformation(String osInformation) {
        this.mExtraOsInformation = osInformation;
    }
}

