/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.bonus;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.Constants;
import com.agateau.pixelwheels.GameWorld;
import com.agateau.pixelwheels.ZLevel;
import com.agateau.pixelwheels.gameobject.Explosable;
import com.agateau.pixelwheels.gameobject.GameObjectAdapter;
import com.agateau.pixelwheels.map.Material;
import com.agateau.pixelwheels.racer.Racer;
import com.agateau.pixelwheels.racer.Vehicle;
import com.agateau.pixelwheels.racescreen.Collidable;
import com.agateau.pixelwheels.sound.AudioManager;
import com.agateau.pixelwheels.utils.BodyRegionDrawer;
import com.agateau.pixelwheels.utils.Box2DUtils;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.CircleShape;
import com.badlogic.gdx.physics.box2d.Contact;
import com.badlogic.gdx.physics.box2d.ContactImpulse;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.Joint;
import com.badlogic.gdx.physics.box2d.Manifold;
import com.badlogic.gdx.physics.box2d.joints.WeldJointDef;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.ReflectionPool;

public class Mine
extends GameObjectAdapter
implements Collidable,
Pool.Poolable,
Disposable,
Explosable {
    private static final ReflectionPool<Mine> sPool = new ReflectionPool<Mine>(Mine.class);
    private static final float MINE_RADIUS = 0.8f;
    private GameWorld mGameWorld;
    private AudioManager mAudioManager;
    private Assets mAssets;
    private Racer mOwner;
    private BodyDef mBodyDef;
    private final WeldJointDef mJointDef = new WeldJointDef();
    private CircleShape mShape;
    private Body mBody;
    private float mTime;
    private Joint mJoint;
    private static final Vector2 sTmp = new Vector2();
    private final BodyRegionDrawer mBodyRegionDrawer = new BodyRegionDrawer();

    public static Mine createAttachedMine(GameWorld gameWorld, Assets assets, AudioManager audioManager, Racer owner) {
        Vehicle vehicle = owner.getVehicle();
        sTmp.set(-vehicle.getWidth(), 0.0f);
        sTmp.rotate(vehicle.getAngle()).add(vehicle.getX(), vehicle.getY());
        Mine mine = Mine.createInternal(gameWorld, assets, audioManager, sTmp);
        mine.mOwner = owner;
        mine.initJoint();
        return mine;
    }

    public static Mine createDroppedMine(GameWorld gameWorld, Assets assets, AudioManager audioManager, Vector2 position) {
        Mine mine = Mine.createInternal(gameWorld, assets, audioManager, position);
        mine.mBody.setType(BodyDef.BodyType.StaticBody);
        return mine;
    }

    private static Mine createInternal(GameWorld gameWorld, Assets assets, AudioManager audioManager, Vector2 position) {
        Mine mine = (Mine)sPool.obtain();
        if (mine.mBodyDef == null) {
            mine.firstInit(assets);
        }
        mine.mGameWorld = gameWorld;
        mine.mAudioManager = audioManager;
        mine.mOwner = null;
        mine.mTime = 0.0f;
        mine.mJoint = null;
        mine.setFinished(false);
        mine.mBodyDef.position.set(position);
        mine.mBody = gameWorld.getBox2DWorld().createBody(mine.mBodyDef);
        mine.mBody.createFixture(mine.mShape, 1.0E-5f);
        mine.mBody.setUserData(mine);
        mine.mBody.setType(BodyDef.BodyType.DynamicBody);
        Box2DUtils.setCollisionInfo(mine.mBody, 8, 7);
        gameWorld.addGameObject(mine);
        return mine;
    }

    private void firstInit(Assets assets) {
        this.mAssets = assets;
        this.mBodyDef = new BodyDef();
        this.mBodyDef.type = BodyDef.BodyType.DynamicBody;
        this.mShape = new CircleShape();
        this.mShape.setRadius(0.8f);
    }

    private void initJoint() {
        Body vehicleBody = this.mOwner.getVehicle().getBody();
        this.mJointDef.bodyA = this.mOwner.getVehicle().getBody();
        this.mJointDef.bodyB = this.mBody;
        this.mJointDef.localAnchorA.set(vehicleBody.getLocalCenter().add(-this.mOwner.getVehicle().getWidth(), 0.0f));
        this.mJointDef.localAnchorB.set(this.mBody.getLocalCenter());
        this.mJoint = this.mGameWorld.getBox2DWorld().createJoint(this.mJointDef);
    }

    @Override
    public void reset() {
        this.mGameWorld.getBox2DWorld().destroyBody(this.mBody);
        this.mBody = null;
    }

    @Override
    public void dispose() {
        sPool.free(this);
    }

    @Override
    public void act(float delta) {
        this.mTime += delta;
    }

    @Override
    public void draw(Batch batch, ZLevel zLevel, Rectangle viewBounds) {
        boolean drawShadow;
        this.mBodyRegionDrawer.setBatch(batch);
        Material material = this.mGameWorld.getTrack().getMaterialAt(this.getPosition());
        boolean hasBeenDropped = this.mJoint == null;
        boolean bl = drawShadow = !hasBeenDropped || !material.isWater();
        if (hasBeenDropped) {
            switch (material) {
                case WATER: {
                    batch.setColor(Constants.HALF_IMMERSED_COLOR);
                    break;
                }
                case DEEP_WATER: {
                    batch.setColor(Constants.FULLY_IMMERSED_COLOR);
                    break;
                }
            }
        } else {
            batch.setColor(this.mOwner.getVehicleRenderer().getBatchColor());
        }
        if (zLevel == ZLevel.GROUND && drawShadow) {
            float z = hasBeenDropped ? -0.1f : 0.0f;
            this.mBodyRegionDrawer.setZ(z);
            TextureRegion region = this.mAssets.mine.getKeyFrame(this.mTime);
            this.mBodyRegionDrawer.drawShadow(this.mBody, region);
        }
        if (zLevel == ZLevel.ON_GROUND) {
            TextureRegion region = this.mAssets.mine.getKeyFrame(this.mTime);
            this.mBodyRegionDrawer.draw(this.mBody, region);
        }
        batch.setColor(Color.WHITE);
    }

    @Override
    public float getX() {
        return this.mBody.getPosition().x;
    }

    @Override
    public float getY() {
        return this.mBody.getPosition().y;
    }

    @Override
    public void explode() {
        if (this.mJoint != null) {
            this.mOwner.resetBonus();
        }
        this.setFinished(true);
        Vector2 pos = this.mBody.getPosition();
        this.mGameWorld.addGameObject(this.mAssets.createExplosion(this.mAudioManager, pos.x, pos.y));
    }

    @Override
    public void beginContact(Contact contact, Fixture otherFixture) {
        Object other = otherFixture.getBody().getUserData();
        if (!(other instanceof Racer)) {
            return;
        }
        if (this.mJoint != null && other == this.mOwner) {
            return;
        }
        this.explode();
        ((Racer)other).disrupt();
    }

    @Override
    public void endContact(Contact contact, Fixture otherFixture) {
    }

    @Override
    public void preSolve(Contact contact, Fixture otherFixture, Manifold oldManifold) {
    }

    @Override
    public void postSolve(Contact contact, Fixture otherFixture, ContactImpulse impulse) {
    }

    public void drop() {
        this.mGameWorld.getBox2DWorld().destroyJoint(this.mJoint);
        this.mJoint = null;
        this.mBody.setType(BodyDef.BodyType.StaticBody);
    }
}

