/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.gameinput;

import com.agateau.pixelwheels.GameConfig;
import com.agateau.pixelwheels.gameinput.GameInputHandler;
import com.agateau.ui.GamepadInputMappers;
import com.agateau.utils.log.NLog;
import com.badlogic.gdx.utils.Array;

public class EnoughInputsChecker {
    private final GameConfig mGameConfig;
    private final Listener mListener;
    private final Array<String> mInputNames = new Array();
    private int mMissingInputCount = 0;
    private int mInputCount = 0;

    public EnoughInputsChecker(GameConfig gameConfig, Listener listener) {
        this.mGameConfig = gameConfig;
        this.mListener = listener;
        GamepadInputMappers.getInstance().addListener(new GamepadInputMappers.Listener(){

            @Override
            public void onGamepadConnected() {
                EnoughInputsChecker.this.onGamepadConnected();
            }

            @Override
            public void onGamepadDisconnected() {
                EnoughInputsChecker.this.onGamepadDisconnected();
            }
        });
    }

    public int getInputCount() {
        return this.mInputCount;
    }

    public Array<String> getInputNames() {
        return this.mInputNames;
    }

    public void setInputCount(int inputCount) {
        this.mInputCount = inputCount;
        if (this.mInputCount == 0) {
            return;
        }
        this.update();
        if (!this.hasEnoughInputs()) {
            this.mListener.onNotEnoughInputs();
        }
    }

    private void update() {
        this.mInputNames.clear();
        this.mMissingInputCount = 0;
        for (int idx = 0; idx < this.mInputCount; ++idx) {
            GameInputHandler handler = this.mGameConfig.getPlayerInputHandler(idx);
            if (handler == null || !handler.isAvailable()) {
                NLog.e("Controller for player %d is not available (handler=%s)", idx + 1, handler);
                ++this.mMissingInputCount;
                this.mInputNames.add(null);
                continue;
            }
            String name = handler.getName();
            if (name.equals("")) {
                name = handler.getTypeName();
            }
            this.mInputNames.add(name);
        }
    }

    private void onGamepadConnected() {
        if (this.mInputCount == 0 | this.hasEnoughInputs()) {
            return;
        }
        this.update();
        if (this.hasEnoughInputs()) {
            this.mListener.onEnoughInputs();
        } else {
            this.mListener.onNotEnoughInputs();
        }
    }

    private void onGamepadDisconnected() {
        if (this.mInputCount == 0) {
            return;
        }
        this.update();
        if (!this.hasEnoughInputs()) {
            this.mListener.onNotEnoughInputs();
        }
    }

    private boolean hasEnoughInputs() {
        return this.mMissingInputCount == 0;
    }

    public static interface Listener {
        public void onNotEnoughInputs();

        public void onEnoughInputs();
    }
}

