/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.gameobject;

import com.agateau.utils.Assert;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;

public class CellFrameBufferManager {
    private static final int SIZE = 1024;
    private final FrameBuffer mFrameBuffer;
    private float mCurrentRowTop = 0.0f;
    private final Vector2 mTmp = new Vector2();
    private final Array<Rectangle> mCells = new Array();
    private Batch mBatch;
    private final Matrix4 mOldProjectionMatrix = new Matrix4();
    private final Matrix4 mProjectionMatrix = new Matrix4();

    public CellFrameBufferManager() {
        this.mFrameBuffer = new FrameBuffer(Pixmap.Format.RGBA8888, 1024, 1024, false);
        ((Texture)this.mFrameBuffer.getColorBufferTexture()).setFilter(Texture.TextureFilter.Nearest, Texture.TextureFilter.Nearest);
        this.mProjectionMatrix.setToOrtho2D(0.0f, 0.0f, 1024.0f, 1024.0f);
    }

    public int reserveCell(int width, int height) {
        float cellX = 0.0f;
        float cellY = 0.0f;
        if (!this.mCells.isEmpty()) {
            Rectangle lastCell = this.mCells.get(this.mCells.size - 1);
            cellX = lastCell.x + lastCell.width;
            cellY = lastCell.y;
            if (cellX + (float)width > 1024.0f) {
                cellX = 0.0f;
                cellY = this.mCurrentRowTop;
            }
        }
        this.mCurrentRowTop = Math.max(cellY + (float)height, this.mCurrentRowTop);
        Assert.check(this.mCurrentRowTop < 1024.0f, "Not enough space to fit cell", new Object[0]);
        Rectangle cell = new Rectangle(cellX, cellY, width, height);
        this.mCells.add(cell);
        return this.mCells.size - 1;
    }

    public float getCellCenterX(int id) {
        Rectangle rect = this.mCells.get(id);
        return rect.x + rect.width / 2.0f;
    }

    public float getCellCenterY(int id) {
        Rectangle rect = this.mCells.get(id);
        return rect.y + rect.height / 2.0f;
    }

    public void begin(Batch batch) {
        this.mBatch = batch;
        this.mOldProjectionMatrix.set(this.mBatch.getProjectionMatrix());
        this.mFrameBuffer.begin();
        this.mBatch.begin();
        this.mBatch.setProjectionMatrix(this.mProjectionMatrix);
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        Gdx.gl.glClear(16384);
    }

    public void end(int x, int y, int width, int height) {
        this.mBatch.end();
        this.mFrameBuffer.end(x, y, width, height);
        this.mBatch.setProjectionMatrix(this.mOldProjectionMatrix);
    }

    public void drawCell(Batch batch, Vector2 dst, int cellId) {
        this.drawCell(batch, dst.x, dst.y, cellId);
    }

    public void drawCell(Batch batch, float dstX, float dstY, int cellId) {
        this.drawScaledCell(batch, dstX, dstY, cellId, 1.0f);
    }

    public void drawScaledCell(Batch batch, Vector2 dst, int cellId, float scale) {
        this.drawScaledCell(batch, dst.x, dst.y, cellId, scale);
    }

    public void drawScaledCell(Batch batch, float dstX, float dstY, int cellId, float scale) {
        Rectangle rect = this.mCells.get(cellId);
        float w = 0.05f * rect.width * scale;
        float h = 0.05f * rect.height * scale;
        float textureSize = 1024.0f;
        float u = rect.x / textureSize;
        float v = rect.y / textureSize;
        float u2 = (rect.x + rect.width) / textureSize;
        float v2 = (rect.y + rect.height) / textureSize;
        batch.draw((Texture)this.mFrameBuffer.getColorBufferTexture(), dstX - w / 2.0f, dstY - h / 2.0f, w, h, u, v, u2, v2);
    }
}

