/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.map;

import com.agateau.pixelwheels.map.LapPosition;
import com.agateau.pixelwheels.map.Warper;
import com.agateau.utils.Assert;
import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;

public class LapPositionTable {
    private final Array<LapSection> mSections = new Array();

    public void addSection(Polygon polygon) {
        int sectionId = this.mSections.size;
        this.mSections.add(new LapSection(sectionId, polygon));
    }

    public LapPosition get(int x, int y) {
        for (LapSection zone : this.mSections) {
            if (!zone.mPolygon.contains(x, y)) continue;
            return zone.computePosition(x, y);
        }
        return null;
    }

    public int getSectionCount() {
        return this.mSections.size;
    }

    private static class LapSection {
        private final int mSectionId;
        private final Polygon mPolygon;
        private final Warper mWarper = new Warper();
        private final LapPosition mLapPosition = new LapPosition();

        public LapSection(int sectionId, Polygon polygon) {
            this.mSectionId = sectionId;
            this.mPolygon = polygon;
            float[] vertices = this.mPolygon.getTransformedVertices();
            int verticeCount = vertices.length / 2;
            Assert.check(verticeCount == 4, "Polygon " + sectionId + " must have 4 vertices, not " + verticeCount, new Object[0]);
            this.mWarper.setSource(vertices[0], vertices[1], vertices[2], vertices[3], vertices[4], vertices[5], vertices[6], vertices[7]);
            this.mWarper.setDestination(0.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 0.0f, 1.0f);
        }

        public LapPosition computePosition(float x, float y) {
            Vector2 out = this.mWarper.warp(x, y);
            this.mLapPosition.init(this.mSectionId, this.mPolygon, x, y, out.x);
            return this.mLapPosition;
        }
    }
}

