/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.map;

import com.agateau.libgdx.AgcTmxMapLoader;
import com.agateau.pixelwheels.GamePlay;
import com.agateau.pixelwheels.gamesetup.Difficulty;
import com.agateau.pixelwheels.map.Championship;
import com.agateau.pixelwheels.map.LapPositionTable;
import com.agateau.pixelwheels.map.LapPositionTableIO;
import com.agateau.pixelwheels.map.MapUtils;
import com.agateau.pixelwheels.map.Material;
import com.agateau.pixelwheels.map.WaypointStore;
import com.agateau.pixelwheels.stats.TrackStats;
import com.agateau.pixelwheels.utils.OrientedPoint;
import com.agateau.translations.Translator;
import com.agateau.utils.Assert;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.maps.MapLayer;
import com.badlogic.gdx.maps.MapObject;
import com.badlogic.gdx.maps.MapObjects;
import com.badlogic.gdx.maps.MapProperties;
import com.badlogic.gdx.maps.objects.EllipseMapObject;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTile;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.TiledMapTileSet;
import com.badlogic.gdx.maps.tiled.TmxMapLoader;
import com.badlogic.gdx.math.Ellipse;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;

public class Track
implements Disposable {
    private static final int CELL_ID_ROW_STRIDE = 10000;
    private final WeakReference<Championship> mChampionship;
    private final String mId;
    private final String mMapName;
    private final HashMap<Difficulty, HashMap<TrackStats.ResultType, ArrayList<Float>>> mDefaultRecords = new HashMap();
    private TiledMap mMap;
    private Material[] mMaterialForTileId;
    private int mStartTileId = -1;
    private Array<TiledMapTileLayer> mBackgroundLayers;
    private Array<TiledMapTileLayer> mForegroundLayers;
    private MapLayer mObstaclesLayer;
    private final WaypointStore mWaypointStore = new WaypointStore();
    private float mTileWidth;
    private float mTileHeight;
    private LapPositionTable mLapPositionTable;
    private Color mBackgroundColor;
    private static final TmxMapLoader sMapLoader = new AgcTmxMapLoader();
    private static final TmxMapLoader.Parameters sMapLoaderParameters = new TmxMapLoader.Parameters();

    public Track(Championship championship, String id, String name) {
        this.mChampionship = new WeakReference<Championship>(championship);
        this.mId = id;
        this.mMapName = name;
        for (Difficulty difficulty : Difficulty.values()) {
            HashMap map = new HashMap();
            this.mDefaultRecords.put(difficulty, map);
            for (TrackStats.ResultType type : TrackStats.ResultType.values()) {
                map.put(type, new ArrayList());
            }
        }
    }

    public void init() {
        if (this.mMap != null) {
            return;
        }
        String path = Gdx.files.internal("maps/" + this.mId + ".tmx").path();
        this.mMap = sMapLoader.load(path, sMapLoaderParameters);
        this.mMaterialForTileId = this.computeMaterialForTileId();
        this.findSpecialTileIds();
        this.findLayers();
        this.mTileWidth = 0.05f * (float)this.mBackgroundLayers.get(0).getTileWidth();
        this.mTileHeight = 0.05f * (float)this.mBackgroundLayers.get(0).getTileHeight();
        this.mLapPositionTable = LapPositionTableIO.load(this.mMap);
        this.readWaypoints();
        String bgColorText = this.mMap.getProperties().get("backgroundcolor", "#808080", String.class);
        bgColorText = bgColorText.substring(1);
        this.mBackgroundColor = Color.valueOf(bgColorText);
    }

    public Championship getChampionship() {
        return (Championship)this.mChampionship.get();
    }

    private void findLayers() {
        this.mBackgroundLayers = this.findLayersMatching("bg");
        Assert.check(this.mBackgroundLayers.size > 0, "No background layers found", new Object[0]);
        this.mForegroundLayers = this.findLayersMatching("fg");
        this.mObstaclesLayer = this.mMap.getLayers().get("Obstacles");
        Assert.check(this.mObstaclesLayer != null, "No \"Obstacles\" layer found", new Object[0]);
    }

    private Array<TiledMapTileLayer> findLayersMatching(String match) {
        Array<TiledMapTileLayer> array = new Array<TiledMapTileLayer>();
        for (int idx = 0; idx < this.mMap.getLayers().getCount(); ++idx) {
            MapLayer layer = this.mMap.getLayers().get(idx);
            if (!layer.getName().startsWith(match)) continue;
            array.add((TiledMapTileLayer)layer);
        }
        return array;
    }

    public String getId() {
        return this.mId;
    }

    public Color getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public int getTotalLapCount() {
        return GamePlay.instance.oneLapOnly ? 1 : 3;
    }

    public TiledMap getMap() {
        return this.mMap;
    }

    public float getTileWidth() {
        return this.mTileWidth;
    }

    public float getTileHeight() {
        return this.mTileHeight;
    }

    public float getMapWidth() {
        return this.mTileWidth * (float)this.mBackgroundLayers.get(0).getWidth();
    }

    public float getMapHeight() {
        return this.mTileHeight * (float)this.mBackgroundLayers.get(0).getHeight();
    }

    public MapObjects getObstacleObjects() {
        return this.mObstaclesLayer.getObjects();
    }

    public LapPositionTable getLapPositionTable() {
        return this.mLapPositionTable;
    }

    public WaypointStore getWaypointStore() {
        return this.mWaypointStore;
    }

    public int[] getExtraBackgroundLayerIndexes() {
        int[] indexes = new int[this.mBackgroundLayers.size - 1];
        for (int idx = 1; idx < this.mBackgroundLayers.size; ++idx) {
            indexes[idx - 1] = idx;
        }
        return indexes;
    }

    public int[] getForegroundLayerIndexes() {
        int[] indexes = new int[this.mForegroundLayers.size];
        int start = this.mBackgroundLayers.size;
        for (int idx = 0; idx < this.mForegroundLayers.size; ++idx) {
            indexes[idx] = start + idx;
        }
        return indexes;
    }

    public ArrayList<Float> getDefaultTrackRecords(Difficulty difficulty, TrackStats.ResultType resultType) {
        return this.mDefaultRecords.get((Object)difficulty).get((Object)resultType);
    }

    private Material[] computeMaterialForTileId() {
        TiledMapTileSet tileSet = this.mMap.getTileSets().getTileSet(0);
        int maxId = 0;
        for (TiledMapTile tile : tileSet) {
            maxId = Math.max(maxId, tile.getId());
        }
        Material[] array = new Material[maxId + 1];
        for (int id = 0; id < array.length; ++id) {
            TiledMapTile tile = tileSet.getTile(id);
            array[id] = MapUtils.getTileMaterial(tile);
        }
        return array;
    }

    private void findSpecialTileIds() {
        TiledMapTileSet tileSet = this.mMap.getTileSets().getTileSet(0);
        for (TiledMapTile tile : tileSet) {
            MapProperties properties = tile.getProperties();
            if (!MapUtils.getBooleanProperty(properties, "start", false)) continue;
            this.mStartTileId = tile.getId();
        }
        Assert.check(this.mStartTileId != -1, "No start id", new Object[0]);
    }

    private TiledMapTile getTopTileAt(Array<TiledMapTileLayer> layers, float x, float y) {
        int tx = MathUtils.floor(x / this.mTileWidth);
        int ty = MathUtils.floor(y / this.mTileHeight);
        for (int idx = layers.size - 1; idx >= 0; --idx) {
            TiledMapTileLayer.Cell cell = layers.get(idx).getCell(tx, ty);
            if (cell == null) continue;
            return cell.getTile();
        }
        return null;
    }

    public long getCellIdAt(float x, float y) {
        int tx = MathUtils.floor(x / this.mTileWidth);
        int ty = MathUtils.floor(y / this.mTileHeight);
        return ty * 10000 + tx;
    }

    public Material getMaterialAt(Vector2 pos) {
        return this.getMaterialAt(pos.x, pos.y);
    }

    public Material getMaterialAt(float x, float y) {
        TiledMapTile tile = this.getTopTileAt(this.mBackgroundLayers, x, y);
        if (tile == null) {
            return Material.ROAD;
        }
        return this.mMaterialForTileId[tile.getId()];
    }

    @Override
    public void dispose() {
        this.mMap.dispose();
        this.mMap = null;
    }

    public Array<Vector2> findStartTilePositions() {
        Array<Vector2> lst = new Array<Vector2>();
        TiledMapTileLayer groundLayer = this.mBackgroundLayers.get(0);
        for (int ty = 0; ty < groundLayer.getHeight(); ++ty) {
            for (int tx = 0; tx < groundLayer.getWidth(); ++tx) {
                int tileId;
                TiledMapTileLayer.Cell cell = groundLayer.getCell(tx, ty);
                if (cell == null || (tileId = cell.getTile().getId()) != this.mStartTileId) continue;
                Vector2 pos = new Vector2((float)tx * this.mTileWidth + this.mTileWidth / 2.0f, (float)ty * this.mTileHeight);
                lst.add(pos);
            }
        }
        return lst;
    }

    public Array<Vector2> findBonusSpotPositions() {
        float U = 0.05f;
        MapLayer layer = this.mMap.getLayers().get("BonusSpots");
        Assert.check(layer != null, "No BonusSpots layer", new Object[0]);
        Array<Vector2> lst = new Array<Vector2>();
        for (MapObject object : layer.getObjects()) {
            if (!(object instanceof EllipseMapObject)) {
                throw new RuntimeException("BonusSpots layer should contains only ellipses. " + object + " is not an ellipse.");
            }
            Ellipse ellipse = ((EllipseMapObject)object).getEllipse();
            Vector2 pos = new Vector2(ellipse.x * 0.05f, ellipse.y * 0.05f);
            lst.add(pos);
        }
        return lst;
    }

    private void readWaypoints() {
        MapLayer layer = this.mMap.getLayers().get("Waypoints");
        Assert.check(layer != null, "No Waypoints layer", new Object[0]);
        this.mWaypointStore.read(layer, this.mLapPositionTable);
    }

    public OrientedPoint getValidPosition(Vector2 pos, float lapDistance) {
        return this.mWaypointStore.getValidPosition(pos, lapDistance);
    }

    public String getMapName() {
        return Translator.trc(this.mMapName, "track");
    }

    public String toString() {
        return this.getId();
    }

    static {
        Track.sMapLoaderParameters.textureMinFilter = Texture.TextureFilter.Linear;
        Track.sMapLoaderParameters.textureMagFilter = Texture.TextureFilter.Linear;
    }
}

