/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.racer;

import com.agateau.pixelwheels.bonus.BonusSpot;
import com.agateau.pixelwheels.racer.Racer;
import com.agateau.pixelwheels.racescreen.Collidable;
import com.badlogic.gdx.physics.box2d.Contact;
import com.badlogic.gdx.physics.box2d.ContactImpulse;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.Manifold;

public class BonusSpotHitComponent
implements Racer.Component,
Collidable {
    private final Racer mRacer;
    private boolean mMustSelectBonus = false;

    public BonusSpotHitComponent(Racer racer) {
        this.mRacer = racer;
    }

    @Override
    public void beginContact(Contact contact, Fixture otherFixture) {
        Object other = otherFixture.getBody().getUserData();
        if (other instanceof BonusSpot) {
            BonusSpot spot = (BonusSpot)other;
            spot.pickBonus();
            if (this.mRacer.getBonus() == null) {
                this.mMustSelectBonus = true;
            }
        }
    }

    @Override
    public void endContact(Contact contact, Fixture otherFixture) {
    }

    @Override
    public void preSolve(Contact contact, Fixture otherFixture, Manifold oldManifold) {
    }

    @Override
    public void postSolve(Contact contact, Fixture otherFixture, ContactImpulse impulse) {
    }

    @Override
    public void act(float delta) {
        if (this.mMustSelectBonus) {
            this.mMustSelectBonus = false;
            this.mRacer.selectBonus();
        }
    }
}

