/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.racescreen;

import com.agateau.pixelwheels.GameWorld;
import com.agateau.pixelwheels.map.Track;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;

abstract class CameraUpdater {
    static final float IMMEDIATE = -1.0f;
    private static final float MAX_ZOOM_DELTA = 0.6f;
    static final float MAX_CAMERA_DELTA = 180.0f;
    final GameWorld mWorld;
    private OrthographicCamera mCamera;
    int mScreenWidth;
    int mScreenHeight;
    CameraInfo mCameraInfo = new CameraInfo();
    CameraInfo mNextCameraInfo = new CameraInfo();

    CameraUpdater(GameWorld world) {
        this.mWorld = world;
    }

    public void init(OrthographicCamera camera, int screenWidth, int screenHeight) {
        this.mCamera = camera;
        this.mScreenWidth = screenWidth;
        this.mScreenHeight = screenHeight;
    }

    public abstract void update(float var1);

    void applyChanges() {
        this.mCamera.up.set(MathUtils.cos(this.mNextCameraInfo.cameraUp), MathUtils.sin(this.mNextCameraInfo.cameraUp), 0.0f);
        this.mCamera.viewportWidth = this.mNextCameraInfo.viewportWidth;
        this.mCamera.viewportHeight = this.mNextCameraInfo.viewportHeight;
        this.mCamera.position.set(this.mNextCameraInfo.position, 0.0f);
        this.mCamera.update();
        CameraInfo tmp = this.mCameraInfo;
        this.mCameraInfo = this.mNextCameraInfo;
        this.mNextCameraInfo = tmp;
    }

    void limitZoomChange(float delta) {
        if (delta < 0.0f) {
            return;
        }
        float zoomDelta = 0.6f * delta;
        this.mNextCameraInfo.zoom = MathUtils.clamp(this.mNextCameraInfo.zoom, this.mCameraInfo.zoom - zoomDelta, this.mCameraInfo.zoom + zoomDelta);
    }

    static class CameraInfo {
        float viewportWidth;
        float viewportHeight;
        Vector2 position = new Vector2();
        float cameraUp = 1.5707964f;
        float cameraAhead = 0.0f;
        float zoom = 1.0f;

        CameraInfo() {
        }

        void clampPositionToTrack(Track track) {
            float minWidth = this.viewportWidth / 2.0f;
            float minHeight = this.viewportHeight / 2.0f;
            float maxWidth = track.getMapWidth() - this.viewportWidth / 2.0f;
            float maxHeight = track.getMapHeight() - this.viewportHeight / 2.0f;
            this.position.x = minWidth < maxWidth ? MathUtils.clamp(this.position.x, minWidth, maxWidth) : track.getMapWidth() / 2.0f;
            this.position.y = minHeight < maxHeight ? MathUtils.clamp(this.position.y, minHeight, maxHeight) : track.getMapHeight() / 2.0f;
        }
    }
}

