/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.rewards;

import com.agateau.pixelwheels.rewards.RewardRule;
import com.agateau.pixelwheels.stats.GameStats;
import com.agateau.pixelwheels.utils.StringUtils;

public class CounterRewardRule
implements RewardRule {
    private final GameStats.Event mEvent;
    private final int mCount;
    private final String mUnlockText;

    public CounterRewardRule(GameStats.Event event, int count, String unlockText) {
        this.mEvent = event;
        this.mCount = count;
        this.mUnlockText = unlockText;
    }

    @Override
    public boolean hasBeenUnlocked(GameStats gameStats) {
        return gameStats.getEventCount(this.mEvent) >= this.mCount;
    }

    @Override
    public String getUnlockText(GameStats gameStats) {
        int current = gameStats.getEventCount(this.mEvent);
        String text = StringUtils.format(this.mUnlockText, this.mCount);
        return StringUtils.format("%s (%d/%d)", text, current, this.mCount);
    }
}

