/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.vehicledef;

import com.agateau.pixelwheels.TextureRegionProvider;
import com.agateau.pixelwheels.vehicledef.AxleDef;
import com.agateau.translations.Translator;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Shape2D;
import com.badlogic.gdx.utils.Array;

public class VehicleDef {
    public final String id;
    private final String mName;
    public float speed;
    public Array<AxleDef> axles = new Array();
    public Array<Shape2D> shapes = new Array();
    String mainImage;

    public VehicleDef(String id, String name) {
        this.id = id;
        this.mName = name;
    }

    public TextureRegion getImage(TextureRegionProvider provider) {
        return provider.findRegions("vehicles/" + this.mainImage).get(0);
    }

    public Animation<TextureRegion> getAnimation(TextureRegionProvider provider) {
        Array<TextureAtlas.AtlasRegion> regions = provider.findRegions("vehicles/" + this.mainImage);
        return new Animation<TextureRegion>(0.2f, regions);
    }

    public String toString() {
        return "vehicleDef(" + this.id + ")";
    }

    public String getName() {
        return Translator.trc(this.mName, "vehicle");
    }
}

