/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels;

import com.agateau.pixelwheels.gameinput.GameInputHandler;
import com.agateau.pixelwheels.gameinput.GameInputHandlerFactories;
import com.agateau.pixelwheels.gameinput.GameInputHandlerFactory;
import com.agateau.pixelwheels.gamesetup.Difficulty;
import com.agateau.pixelwheels.gamesetup.GameMode;
import com.agateau.utils.Assert;
import com.agateau.utils.log.NLog;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.DelayedRemovalArray;
import java.util.LinkedHashMap;
import java.util.Map;

public class GameConfig {
    public static final float HUD_ZOOM_AUTO = 0.0f;
    public boolean fullscreen = false;
    public boolean headingUpCamera = false;
    public boolean playSoundFx = true;
    public boolean playMusic = true;
    public String languageId = "";
    public float hudZoom = 0.0f;
    public GameMode gameMode = GameMode.QUICK_RACE;
    public final String[] vehicles = new String[4];
    public String track;
    public String championship;
    public Difficulty difficulty = Difficulty.EASY;
    private final String[] mPlayerInputFactoryIds = new String[4];
    private final GameInputHandler[] mPlayerInputHandlers = new GameInputHandler[4];
    private final Preferences mPreferences;
    private final DelayedRemovalArray<ChangeListener> mListeners = new DelayedRemovalArray();

    GameConfig() {
        this(Gdx.app.getPreferences("pixelwheels.conf"));
    }

    GameConfig(Preferences preferences) {
        this.mPreferences = preferences;
        this.load();
        this.addListener(group -> {
            if (group == ConfigGroup.INPUT) {
                this.setupInputHandlers();
            }
        });
    }

    private void load() {
        this.fullscreen = this.mPreferences.getBoolean("fullscreen", false);
        this.headingUpCamera = this.mPreferences.getBoolean("headingUpCamera", false);
        this.playSoundFx = this.mPreferences.getBoolean("soundFx", true);
        this.playMusic = this.mPreferences.getBoolean("music", true);
        try {
            this.gameMode = GameMode.valueOf(this.mPreferences.getString("gameMode"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.difficulty = Difficulty.valueOf(this.mPreferences.getString("difficulty"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        for (int idx = 0; idx < 4; ++idx) {
            this.mPlayerInputFactoryIds[idx] = this.mPreferences.getString("input." + idx, "");
            this.vehicles[idx] = this.mPreferences.getString("vehicleId." + idx);
        }
        this.track = this.mPreferences.getString("trackId");
        this.championship = this.mPreferences.getString("championshipId");
        this.languageId = this.mPreferences.getString("languageId");
        this.hudZoom = this.mPreferences.getFloat("hudZoom", 0.0f);
        this.setupInputHandlers();
    }

    public void addListener(ChangeListener listener) {
        this.mListeners.add(listener);
    }

    public void flush(ConfigGroup group) {
        switch (group) {
            case INPUT: {
                int idx;
                for (idx = 0; idx < this.vehicles.length; ++idx) {
                    this.mPreferences.putString("input." + idx, this.mPlayerInputFactoryIds[idx]);
                }
                break;
            }
            case LANGUAGE: {
                this.mPreferences.putString("languageId", this.languageId);
                break;
            }
            case OTHER: {
                int idx;
                this.mPreferences.putBoolean("fullscreen", this.fullscreen);
                this.mPreferences.putBoolean("headingUpCamera", this.headingUpCamera);
                this.mPreferences.putBoolean("soundFx", this.playSoundFx);
                this.mPreferences.putBoolean("music", this.playMusic);
                this.mPreferences.putString("gameMode", this.gameMode.toString());
                this.mPreferences.putString("difficulty", this.difficulty.toString());
                for (idx = 0; idx < this.vehicles.length; ++idx) {
                    this.mPreferences.putString("vehicleId." + idx, this.vehicles[idx]);
                }
                this.mPreferences.putString("trackId", this.track);
                this.mPreferences.putString("championshipId", this.championship);
                this.mPreferences.putFloat("hudZoom", this.hudZoom);
            }
        }
        this.mPreferences.flush();
        this.mListeners.begin();
        for (ChangeListener listener : this.mListeners) {
            listener.onGameConfigChanged(group);
        }
        this.mListeners.end();
    }

    public GameInputHandler getPlayerInputHandler(int index) {
        Assert.check(index < this.mPlayerInputHandlers.length, "Not enough input handlers for index " + index, new Object[0]);
        return this.mPlayerInputHandlers[index];
    }

    public GameInputHandlerFactory getPlayerInputHandlerFactory(int idx) {
        String factoryId = this.mPlayerInputFactoryIds[idx];
        return GameInputHandlerFactories.getFactoryById(factoryId);
    }

    public void setPlayerInputHandlerFactory(int idx, GameInputHandlerFactory factory) {
        this.mPlayerInputFactoryIds[idx] = factory.getId();
    }

    public void savePlayerInputHandlerConfig(int index) {
        Assert.check(index < this.mPlayerInputHandlers.length, "Not enough input handlers for index " + index, new Object[0]);
        GameInputHandler handler = this.mPlayerInputHandlers[index];
        if (handler == null) {
            return;
        }
        String prefix = this.getInputPrefix(index);
        handler.saveConfig(this.mPreferences, prefix);
        this.mPreferences.flush();
    }

    private String getInputPrefix(int idx) {
        return "input." + idx + "." + this.mPlayerInputFactoryIds[idx] + ".";
    }

    private static String simpleString(Object object) {
        String address = Integer.toHexString(object.hashCode());
        return object.getClass().getSimpleName() + '@' + address;
    }

    private void setupInputHandlers() {
        NLog.i("", new Object[0]);
        LinkedHashMap<String, Array<GameInputHandler>> inputHandlersByIds = new LinkedHashMap<String, Array<GameInputHandler>>();
        for (GameInputHandlerFactory factory : GameInputHandlerFactories.getAvailableFactories()) {
            inputHandlersByIds.put(factory.getId(), new Array<GameInputHandler>(factory.getAllHandlers()));
        }
        for (int idx = 0; idx < 4; ++idx) {
            this.mPlayerInputHandlers[idx] = null;
            String id = this.mPlayerInputFactoryIds[idx];
            GameInputHandler inputHandler = null;
            if (!"".equals(id)) {
                inputHandler = GameConfig.popInputHandler((Array)inputHandlersByIds.get(id));
                if (inputHandler != null) {
                    NLog.i("P%d: loading config for %s (%s)", idx + 1, id, GameConfig.simpleString(inputHandler));
                    inputHandler.loadConfig(this.mPreferences, this.getInputPrefix(idx), idx);
                } else {
                    NLog.e("P%d: not enough input handlers for id '%s'", idx + 1, id);
                }
            }
            if (inputHandler == null) {
                NLog.i("P%d: no predefined config, or predefined config not available. Looking for a fallback.", idx + 1);
                for (Map.Entry entry : inputHandlersByIds.entrySet()) {
                    inputHandler = GameConfig.popInputHandler((Array)entry.getValue());
                    if (inputHandler == null) continue;
                    id = (String)entry.getKey();
                    NLog.i("P%d: using %s (%s)", idx + 1, id, GameConfig.simpleString(inputHandler));
                    break;
                }
            }
            Assert.check(inputHandler != null, "Player %d: No input handler available for id '%s'", idx + 1, id);
            this.mPlayerInputHandlers[idx] = inputHandler;
        }
    }

    private static GameInputHandler popInputHandler(Array<GameInputHandler> inputHandlers) {
        if (inputHandlers != null && !inputHandlers.isEmpty()) {
            return inputHandlers.removeIndex(0);
        }
        return null;
    }

    public static interface ChangeListener {
        public void onGameConfigChanged(ConfigGroup var1);
    }

    public static enum ConfigGroup {
        INPUT,
        LANGUAGE,
        OTHER;

    }
}

