/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.bonus;

import com.agateau.pixelwheels.Assets;
import com.agateau.pixelwheels.GameWorld;
import com.agateau.pixelwheels.ZLevel;
import com.agateau.pixelwheels.gameobject.AnimationObject;
import com.agateau.pixelwheels.gameobject.AudioClipper;
import com.agateau.pixelwheels.gameobject.Explosable;
import com.agateau.pixelwheels.gameobject.GameObjectAdapter;
import com.agateau.pixelwheels.racer.Racer;
import com.agateau.pixelwheels.racescreen.Collidable;
import com.agateau.pixelwheels.sound.AudioManager;
import com.agateau.pixelwheels.utils.BodyRegionDrawer;
import com.agateau.pixelwheels.utils.Box2DUtils;
import com.agateau.utils.AgcMathUtils;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Contact;
import com.badlogic.gdx.physics.box2d.ContactImpulse;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.Manifold;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.ReflectionPool;

public class Bullet
extends GameObjectAdapter
implements Collidable,
Pool.Poolable,
Disposable {
    private static final ReflectionPool<Bullet> sPool = new ReflectionPool<Bullet>(Bullet.class);
    private static final float IMPULSE = 160.0f;
    private Racer mShooter;
    private GameWorld mGameWorld;
    private AudioManager mAudioManager;
    private Assets mAssets;
    private BodyDef mBodyDef;
    private PolygonShape mShape;
    private Body mBody;
    private boolean mJustShot = false;
    private final BodyRegionDrawer mDrawer = new BodyRegionDrawer();

    public static Bullet create(Assets assets, GameWorld gameWorld, AudioManager audioManager, Racer shooter, float originX, float originY, float angle) {
        Bullet object = (Bullet)sPool.obtain();
        if (object.mBodyDef == null) {
            object.firstInit(assets);
        }
        object.mShooter = shooter;
        object.mGameWorld = gameWorld;
        object.mAudioManager = audioManager;
        object.setFinished(false);
        object.mJustShot = true;
        object.mBodyDef.position.set(originX, originY);
        object.mBodyDef.angle = angle * ((float)Math.PI / 180);
        object.mBody = gameWorld.getBox2DWorld().createBody(object.mBodyDef);
        object.mBody.createFixture(object.mShape, 0.0f);
        object.mBody.setUserData(object);
        object.mBody.applyLinearImpulse(160.0f * MathUtils.cosDeg(angle), 160.0f * MathUtils.sinDeg(angle), originX, originY, true);
        Box2DUtils.setCollisionInfo(object.mBody, 4, 11);
        return object;
    }

    private void firstInit(Assets assets) {
        this.mAssets = assets;
        this.mBodyDef = new BodyDef();
        this.mBodyDef.type = BodyDef.BodyType.DynamicBody;
        this.mBodyDef.bullet = true;
        this.mShape = new PolygonShape();
        this.mShape.setAsBox((float)assets.bullet.getRegionWidth() * 0.05f / 2.0f, (float)assets.bullet.getRegionHeight() * 0.05f / 2.0f);
    }

    @Override
    public void reset() {
        this.mGameWorld.getBox2DWorld().destroyBody(this.mBody);
        this.mBody = null;
    }

    @Override
    public void dispose() {
        sPool.free(this);
    }

    @Override
    public void act(float delta) {
    }

    @Override
    public void draw(Batch batch, ZLevel zLevel, Rectangle viewBounds) {
        if (zLevel != ZLevel.GROUND) {
            return;
        }
        float radius = this.mBody.getFixtureList().get(0).getShape().getRadius();
        if (!AgcMathUtils.rectangleContains(viewBounds, this.getPosition(), radius)) {
            return;
        }
        this.mDrawer.setBatch(batch);
        this.mDrawer.draw(this.mBody, this.mAssets.bullet);
    }

    @Override
    public void audioRender(AudioClipper clipper) {
        if (this.mJustShot) {
            this.mAudioManager.play(this.mAssets.soundAtlas.get("shoot"), clipper.clip(this));
            this.mJustShot = false;
        }
    }

    @Override
    public float getX() {
        return this.mBody.getPosition().x;
    }

    @Override
    public float getY() {
        return this.mBody.getPosition().y;
    }

    private void explode() {
        Vector2 pos = this.mBody.getPosition();
        AnimationObject obj = AnimationObject.create(this.mAssets.impact, pos.x, pos.y);
        obj.initAudio(this.mAudioManager, this.mAssets.soundAtlas.get("impact"));
        this.mGameWorld.addGameObject(obj);
        this.setFinished(true);
    }

    @Override
    public void beginContact(Contact contact, Fixture otherFixture) {
    }

    @Override
    public void endContact(Contact contact, Fixture otherFixture) {
    }

    @Override
    public void preSolve(Contact contact, Fixture otherFixture, Manifold oldManifold) {
        if (this.isFinished()) {
            return;
        }
        Object other = otherFixture.getBody().getUserData();
        if (other == this.mShooter) {
            contact.setEnabled(false);
            return;
        }
        this.explode();
        if (other instanceof Racer) {
            Racer racer = (Racer)other;
            racer.disrupt();
        } else if (other instanceof Explosable) {
            ((Explosable)other).explode();
        }
    }

    @Override
    public void postSolve(Contact contact, Fixture otherFixture, ContactImpulse impulse) {
    }
}

