/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.bonus;

import com.agateau.pixelwheels.bonus.BonusAdapter;
import com.agateau.pixelwheels.bonus.Mine;
import com.agateau.pixelwheels.racer.Racer;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Pool;

public class MineBonus
extends BonusAdapter
implements Pool.Poolable {
    private static final float AI_KEEP_BONUS_MIN_TIME = 2.0f;
    private static final float AI_KEEP_BONUS_MAX_TIME = 5.0f;
    private Mine mMine;
    private boolean mTriggered;
    private float mAiKeepTime;

    @Override
    public void reset() {
        this.mTriggered = false;
    }

    @Override
    public void onPicked(Racer racer) {
        super.onPicked(racer);
        this.mMine = Mine.createAttachedMine(this.mGameWorld, this.mAssets, this.mAudioManager, this.mRacer);
        this.mAiKeepTime = MathUtils.random(2.0f, 5.0f);
    }

    @Override
    public void trigger() {
        this.mTriggered = true;
    }

    @Override
    public void onOwnerHit() {
        this.mTriggered = true;
    }

    @Override
    public void act(float delta) {
        if (this.mTriggered) {
            this.mRacer.resetBonus();
            this.mMine.drop();
            this.free();
        }
    }

    @Override
    public void aiAct(float delta) {
        this.mAiKeepTime -= delta;
        if (this.mAiKeepTime <= 0.0f) {
            this.mRacer.triggerBonus();
        }
    }
}

