/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui.uibuilder;

import com.agateau.ui.uibuilder.UiBuilder;
import com.badlogic.gdx.utils.XmlReader;
import java.util.HashSet;
import java.util.Set;

class ElementTreeTraversor {
    private final Set<String> mVariables = new HashSet<String>();

    ElementTreeTraversor() {
    }

    void defineVariable(String variable) {
        this.mVariables.add(variable);
    }

    void traverseElementTree(XmlReader.Element parentElement, ElementProcessor elementProcessor) throws UiBuilder.SyntaxException {
        int size = parentElement.getChildCount();
        for (int idx = 0; idx < size; ++idx) {
            XmlReader.Element element = parentElement.getChild(idx);
            if (element.getName().equals("Action")) continue;
            if (element.getName().equals("Ifdef")) {
                XmlReader.Element elseElement = null;
                if (idx + 1 < size) {
                    elseElement = parentElement.getChild(idx + 1);
                    if (elseElement.getName().equals("Else")) {
                        ++idx;
                    } else {
                        elseElement = null;
                    }
                }
                if (this.evaluateIfdef(element)) {
                    this.traverseElementTree(element, elementProcessor);
                    continue;
                }
                if (elseElement == null) continue;
                this.traverseElementTree(elseElement, elementProcessor);
                continue;
            }
            elementProcessor.process(element);
        }
    }

    private boolean evaluateIfdef(XmlReader.Element element) {
        String condition = element.getAttribute("var").trim();
        return this.mVariables.contains(condition);
    }

    static interface ElementProcessor {
        public void process(XmlReader.Element var1) throws UiBuilder.SyntaxException;
    }
}

