/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.bonus;

import com.agateau.pixelwheels.utils.Box2DUtils;
import com.agateau.utils.AgcMathUtils;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;

public class MissileGuidingSystem {
    private static final float MAX_ROTATION = 0.08726646f;
    public static float MAX_SPEED = 44.444447f;
    private Body mBody;
    private final Vector2 mTmp = new Vector2();

    public void init(Body body) {
        this.mBody = body;
    }

    public void act(Vector2 target) {
        this.move();
        if (target == null) {
            return;
        }
        float angle = this.computeAngle(target);
        this.mBody.setTransform(this.mBody.getWorldCenter(), angle);
    }

    private float computeAngle(Vector2 target) {
        this.mTmp.set(target).sub(this.mBody.getWorldCenter());
        float bodyAngle = AgcMathUtils.normalizeAnglePiRad(this.mBody.getAngle());
        float desiredAngle = AgcMathUtils.normalizeAnglePiRad(this.mTmp.angleRad());
        float delta = AgcMathUtils.normalizeAnglePiRad(desiredAngle - bodyAngle);
        return bodyAngle + MathUtils.clamp(delta, -0.08726646f, 0.08726646f);
    }

    private void move() {
        Vector2 velocity = this.mBody.getLinearVelocity();
        float speed = velocity.len();
        float delta = MAX_SPEED - speed;
        float impulse = delta * this.mBody.getMass();
        this.mTmp.set(impulse, 0.0f).rotateRad(this.mBody.getAngle());
        this.mBody.applyLinearImpulse(this.mTmp, this.mBody.getWorldCenter(), true);
        Vector2 latImpulse = Box2DUtils.getLateralVelocity(this.mBody).scl(-this.mBody.getMass());
        this.mBody.applyLinearImpulse(latImpulse, this.mBody.getWorldCenter(), true);
    }
}

