/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.translations;

import com.agateau.translations.Messages;
import com.agateau.translations.PoParserException;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PoParser {
    private static final String CONTEXT_SEPARATOR = "@@@";
    private static final String FUZZY_COMMENT = "#, fuzzy";
    private static final Pattern HEADER_PATTERN = Pattern.compile("Plural-Forms:\\s*nplurals\\s*=\\s*(\\d+)\\s*; plural\\s*=\\s*(.*);");
    private static final HashMap<String, Messages.PluralExpression> sPluralExpressionByString = new HashMap();
    private final BufferedReader mReader;
    private int mLineNumber = 0;
    private State mState = State.EXPECT_MSGID_OR_MSGCTXT;
    private Messages mMessages = null;
    private int mPluralCount;
    private boolean mCurrentEntryIsFuzzy = false;
    private String mMsgCtxt;
    private String mMsgId;
    private String mMsgIdPlural;
    private final ArrayList<String> mMsgStr = new ArrayList();

    PoParser(BufferedReader reader) {
        this.mReader = reader;
    }

    public Messages parse() throws PoParserException {
        String keyword = null;
        StringBuilder keywordArguments = new StringBuilder();
        while (true) {
            String line;
            try {
                ++this.mLineNumber;
                line = this.mReader.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new PoParserException(this.mLineNumber, e.toString());
            }
            if (line == null) break;
            if ((line = line.trim()).startsWith("\"")) {
                if (keyword == null) {
                    throw new PoParserException(this.mLineNumber, "Expected keyword, got continuation line");
                }
                keywordArguments.append(PoParser.parseString(line));
                continue;
            }
            if (keyword != null) {
                this.processKeyword(keyword, keywordArguments.toString());
                keyword = null;
            }
            if (line.startsWith(FUZZY_COMMENT)) {
                this.mCurrentEntryIsFuzzy = true;
                continue;
            }
            if (line.isEmpty() || line.charAt(0) == '#') continue;
            String[] tokens = line.split("\\s+", 2);
            if (tokens.length != 2) {
                throw new PoParserException(this.mLineNumber, "Invalid line, could not find a space");
            }
            keyword = tokens[0];
            keywordArguments.setLength(0);
            keywordArguments.append(PoParser.parseString(tokens[1]));
        }
        if (keyword != null) {
            this.processKeyword(keyword, keywordArguments.toString());
        }
        if (this.mMsgIdPlural != null) {
            this.addCurrentEntry();
        }
        return this.mMessages;
    }

    public static String createIdWithContext(String context, String id) {
        return context + CONTEXT_SEPARATOR + id;
    }

    private void processKeyword(String keyword, String argument) throws PoParserException {
        switch (this.mState) {
            case EXPECT_MSGID_OR_MSGCTXT: {
                if (keyword.equals("msgctxt")) {
                    this.processMsgctxt(argument);
                    break;
                }
                if (keyword.equals("msgid")) {
                    this.processMsgid(argument);
                    break;
                }
                throw new PoParserException(this.mLineNumber - 1, "Expected msgctxt or msgid, got " + keyword);
            }
            case EXPECT_MSGID: {
                if (keyword.equals("msgid")) {
                    this.processMsgid(argument);
                    break;
                }
                throw new PoParserException(this.mLineNumber - 1, "Expected msgid, got " + keyword);
            }
            case GOT_MSGID: {
                if (keyword.equals("msgstr")) {
                    this.mMsgStr.add(argument);
                    this.addCurrentEntry();
                    this.mState = State.EXPECT_MSGID_OR_MSGCTXT;
                    break;
                }
                if (keyword.equals("msgid_plural")) {
                    this.mMsgIdPlural = argument;
                    this.mState = State.EXPECT_MSGSTR_PLURAL;
                    break;
                }
                throw new PoParserException(this.mLineNumber - 1, "Expected msgstr or msgid_plural, got " + keyword);
            }
            case EXPECT_MSGSTR_PLURAL: {
                if (keyword.startsWith("msgstr[")) {
                    this.mMsgStr.add(argument);
                    break;
                }
                if (keyword.equals("msgctxt")) {
                    this.addCurrentEntry();
                    this.processMsgctxt(argument);
                    break;
                }
                if (keyword.equals("msgid")) {
                    this.addCurrentEntry();
                    this.processMsgid(argument);
                    break;
                }
                throw new PoParserException(this.mLineNumber - 1, "Expected msgid or msgstr[N] line, got " + keyword);
            }
        }
    }

    private void processMsgid(String argument) {
        this.mMsgId = argument;
        this.mState = State.GOT_MSGID;
    }

    private void processMsgctxt(String argument) {
        this.mMsgCtxt = argument;
        this.mState = State.EXPECT_MSGID;
    }

    private void addCurrentEntry() throws PoParserException {
        if (this.mMessages == null) {
            this.parseHeader();
        } else if (!this.mCurrentEntryIsFuzzy) {
            this.doAddCurrentEntry();
        }
        this.mMsgCtxt = null;
        this.mMsgId = null;
        this.mMsgIdPlural = null;
        this.mMsgStr.clear();
        this.mCurrentEntryIsFuzzy = false;
    }

    private void parseHeader() throws PoParserException {
        Messages.PluralExpression expression;
        if (!this.mMsgId.equals("")) {
            throw new PoParserException(this.mLineNumber + 1, "Missing header");
        }
        String header = this.mMsgStr.get(0);
        Matcher matcher = HEADER_PATTERN.matcher(header);
        if (!matcher.find()) {
            throw new PoParserException(this.mLineNumber + 1, "Can't find plural definition in header:\n" + header);
        }
        this.mPluralCount = Integer.parseInt(matcher.group(1));
        String expressionString = matcher.group(2).replace(" ", "");
        if (expressionString.startsWith("(") && expressionString.endsWith(")")) {
            expressionString = expressionString.substring(1, expressionString.length() - 1);
        }
        if ((expression = sPluralExpressionByString.get(expressionString)) == null) {
            throw new PoParserException(this.mLineNumber + 1, "Unknown plural expression: " + expressionString);
        }
        this.mMessages = new Messages(expression);
    }

    private void doAddCurrentEntry() throws PoParserException {
        if (this.mMsgIdPlural == null) {
            String id = this.mMsgCtxt == null ? this.mMsgId : PoParser.createIdWithContext(this.mMsgCtxt, this.mMsgId);
            String message = this.mMsgStr.get(0);
            if (message.isEmpty()) {
                return;
            }
            this.mMessages.plainEntries.put(id, message);
        } else {
            if (this.mMsgStr.size() != this.mPluralCount) {
                throw new PoParserException(this.mLineNumber - 1, String.format(Locale.US, "Wrong number of msgstr for plural entry (%s, %s). Expected %d, found %d.", this.mMsgId, this.mMsgIdPlural, this.mPluralCount, this.mMsgStr.size()));
            }
            for (String message : this.mMsgStr) {
                if (!message.isEmpty()) continue;
                return;
            }
            Messages.PluralId pluralId = new Messages.PluralId(this.mMsgId, this.mMsgIdPlural);
            String[] strings = new String[this.mMsgStr.size()];
            this.mMessages.pluralEntries.put(pluralId, this.mMsgStr.toArray(strings));
        }
    }

    static String parseString(String string) {
        string = string.substring(1, string.length() - 1);
        return string.replace("\\\"", "\"").replace("\\n", "\n").replace("\\\\", "\\");
    }

    static {
        sPluralExpressionByString.put("n>1", n -> n > 1 ? 1 : 0);
        sPluralExpressionByString.put("n!=1", n -> n != 1 ? 1 : 0);
        sPluralExpressionByString.put("n==1?0:n%10>=2&&n%10<=4&&(n%100<12||n%100>14)?1:2", n -> n == 1 ? 0 : (n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 12 || n % 100 > 14) ? 1 : 2));
        sPluralExpressionByString.put("n==1?0:n%10>=2&&n%10<=4&&(n%100<10||n%100>=20)?1:2", n -> n == 1 ? 0 : (n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2));
        sPluralExpressionByString.put("0", n -> 0);
        sPluralExpressionByString.put("n%10==1&&n%100!=11?0:n%10>=2&&n%10<=4&&(n%100<12||n%100>14)?1:2", n -> n % 10 == 1 && n % 100 != 11 ? 0 : (n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 12 || n % 100 > 14) ? 1 : 2));
        sPluralExpressionByString.put("n%10==1&&n%100!=11?0:n%10>=2&&n%10<=4&&(n%100<10||n%100>=20)?1:2", n -> n % 10 == 1 && n % 100 != 11 ? 0 : (n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2));
    }

    private static enum State {
        EXPECT_MSGID_OR_MSGCTXT,
        EXPECT_MSGID,
        GOT_MSGID,
        EXPECT_MSGSTR_PLURAL;

    }
}

