/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui.animscript;

import com.agateau.ui.DimensionParser;
import com.agateau.ui.animscript.AnimScriptLoader;
import com.agateau.ui.animscript.ArgumentDefinition;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.Map;

class AlignmentArgumentDefinition
extends ArgumentDefinition<Integer> {
    private static final Map<String, Integer> sMap = new HashMap<String, Integer>();

    AlignmentArgumentDefinition() {
        super(Integer.TYPE, null);
    }

    @Override
    public Object parse(StreamTokenizer tokenizer, DimensionParser dimParser) throws AnimScriptLoader.SyntaxException {
        try {
            tokenizer.nextToken();
        }
        catch (IOException e) {
            throw new AnimScriptLoader.SyntaxException(tokenizer, "Missing token for argument");
        }
        if (tokenizer.ttype != -3) {
            throw new AnimScriptLoader.SyntaxException(tokenizer, "No value set for this argument, which has no default value");
        }
        Integer value = sMap.get(tokenizer.sval);
        if (value == null) {
            throw new AnimScriptLoader.SyntaxException(tokenizer, "Invalid alignment value: " + tokenizer.sval);
        }
        return value;
    }

    static {
        sMap.put("bottomLeft", 12);
        sMap.put("bottomCenter", 4);
        sMap.put("bottomRight", 20);
        sMap.put("centerLeft", 8);
        sMap.put("center", 1);
        sMap.put("centerRight", 16);
        sMap.put("topLeft", 10);
        sMap.put("topCenter", 2);
        sMap.put("topRight", 18);
    }
}

