/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui.menu;

import com.agateau.ui.InputMapper;
import com.agateau.ui.VirtualKey;
import com.agateau.ui.menu.ButtonMenuItem;
import com.agateau.ui.menu.CornerMenuButton;
import com.agateau.ui.menu.CornerMenuItem;
import com.agateau.ui.menu.LabelMenuItem;
import com.agateau.ui.menu.MenuInputHandler;
import com.agateau.ui.menu.MenuItem;
import com.agateau.ui.menu.MenuItemGroup;
import com.agateau.ui.menu.SpacerMenuItem;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.ImageButton;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.Disableable;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;

public class Menu
extends WidgetGroup
implements Disableable {
    private static final float LABEL_COLUMN_WIDTH = 120.0f;
    private final MenuInputHandler mMenuInputHandler = new MenuInputHandler();
    private final MenuItemGroup mGroup;
    private final Skin mSkin;
    private final MenuStyle mStyle;
    private final String mStyleName;
    private float mLabelColumnWidth;
    private boolean mDisabled = false;
    private boolean mFirstLayout = true;

    public MenuItem addItemWithLabelActor(Actor labelActor, MenuItem menuItem) {
        return this.mGroup.addItemWithLabelActor(labelActor, menuItem);
    }

    public Menu(Skin skin) {
        this(skin, "default");
    }

    public Menu(Skin skin, String styleName) {
        this.mSkin = skin;
        this.mStyleName = styleName;
        this.mStyle = this.getMenuStyleByName(styleName);
        this.mGroup = new MenuItemGroup(this);
        this.setLabelColumnWidth(120.0f);
        this.addActor(this.mGroup.getActor());
    }

    public MenuStyle getMenuStyleByName(String styleName) {
        return this.mSkin.get(styleName, MenuStyle.class);
    }

    private CornerMenuButton addCornerButton(CornerMenuItem.Corner corner, String iconName) {
        ImageButton.ImageButtonStyle style = new ImageButton.ImageButtonStyle(this.mSkin.get(this.mStyleName, ImageButton.ImageButtonStyle.class));
        style.imageUp = this.mSkin.getDrawable(iconName);
        CornerMenuButton button = new CornerMenuButton(this, corner, style);
        this.addItem(button);
        return button;
    }

    public CornerMenuButton addBackButton() {
        return this.addCornerButton(CornerMenuItem.Corner.BOTTOM_LEFT, "icon-back");
    }

    public CornerMenuButton addNextButton() {
        return this.addCornerButton(CornerMenuItem.Corner.BOTTOM_RIGHT, "icon-next");
    }

    public Skin getSkin() {
        return this.mSkin;
    }

    public MenuStyle getMenuStyle() {
        return this.mStyle;
    }

    public MenuItemGroup findItemParentGroup(MenuItem item) {
        return this.mGroup.findItemParentGroup(item);
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.mDisabled = disabled;
    }

    @Override
    public boolean isDisabled() {
        return this.mDisabled;
    }

    public void setInputMapper(InputMapper inputMapper) {
        this.mMenuInputHandler.setInputMapper(inputMapper);
    }

    public float getLabelColumnWidth() {
        return this.mLabelColumnWidth;
    }

    public void setLabelColumnWidth(float labelColumnWidth) {
        this.mLabelColumnWidth = labelColumnWidth;
    }

    public ButtonMenuItem addButton(String text) {
        return this.mGroup.addButton(text);
    }

    public LabelMenuItem addLabel(String text) {
        return this.mGroup.addLabel(text);
    }

    public LabelMenuItem addTitleLabel(String text) {
        return this.mGroup.addTitleLabel(text);
    }

    public MenuItem addItem(MenuItem item) {
        return this.mGroup.addItem(item);
    }

    public SpacerMenuItem addSpacer() {
        return this.mGroup.addSpacer();
    }

    public MenuItem addItemWithLabel(String labelText, MenuItem item) {
        return this.addItemWithLabel(labelText, item, "default");
    }

    public MenuItem addItemWithLabel(String labelText, MenuItem item, String labelStyle) {
        return this.mGroup.addItemWithLabel(labelText, item, labelStyle);
    }

    @Override
    public void layout() {
        super.layout();
        this.updateGroupBounds();
        if (this.mFirstLayout) {
            this.mFirstLayout = false;
            this.onFirstLayout();
        }
    }

    private void updateGroupBounds() {
        Actor actor = this.mGroup.getActor();
        actor.setWidth(this.getWidth() - (float)(2 * this.mStyle.focusPadding));
        ((Layout)((Object)actor)).invalidate();
        ((Layout)((Object)actor)).validate();
        actor.setPosition(this.mStyle.focusPadding, this.mStyle.focusPadding);
    }

    private void onFirstLayout() {
        if (this.mGroup.getCurrentItem() == null) {
            this.mGroup.focusFirstItem();
        } else {
            this.mGroup.updateFocusIndicatorBounds();
        }
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        if (this.mDisabled) {
            return;
        }
        this.mMenuInputHandler.act(delta);
        if (this.mMenuInputHandler.isPressed(VirtualKey.DOWN)) {
            this.mGroup.goDown();
        } else if (this.mMenuInputHandler.isPressed(VirtualKey.UP)) {
            this.mGroup.goUp();
        } else if (this.mMenuInputHandler.isPressed(VirtualKey.LEFT)) {
            this.mGroup.goLeft();
        } else if (this.mMenuInputHandler.isPressed(VirtualKey.RIGHT)) {
            this.mGroup.goRight();
        } else if (this.mMenuInputHandler.isJustPressed(VirtualKey.TRIGGER)) {
            this.mGroup.trigger();
        }
    }

    public void setCurrentItem(MenuItem item) {
        this.mGroup.setCurrentItem(item);
    }

    public MenuItem getCurrentItem() {
        return this.mGroup.getCurrentItem();
    }

    public boolean isItemVisible(MenuItem item) {
        return this.mGroup.isItemVisible(item);
    }

    public void setItemVisible(MenuItem item, boolean visible) {
        this.mGroup.setItemVisible(item, visible);
    }

    void onGroupBoundariesChanged() {
        Actor actor = this.mGroup.getActor();
        actor.setPosition(this.mStyle.focusPadding, this.mStyle.focusPadding);
        this.setSize(this.getWidth(), actor.getHeight() + (float)(2 * this.mStyle.focusPadding));
        this.invalidateHierarchy();
    }

    public static class MenuStyle {
        public Drawable focus;
        public Drawable selected;
        public int spacing;
        public int focusPadding;
    }
}

