/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui;

import com.agateau.ui.UiInputMapper;
import com.agateau.ui.VirtualKey;
import com.agateau.utils.Assert;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.VerticalGroup;

public class CreditsScrollPane
extends ScrollPane {
    private static final float AUTO_SCROLL_PX_PER_S = 45.0f;
    private VerticalGroup mGroup;

    public CreditsScrollPane() {
        super((Actor)null);
        this.setupAutoScroll();
    }

    public VerticalGroup getGroup() {
        return this.mGroup;
    }

    @Override
    public void setActor(Actor actor) {
        super.setActor(actor);
        if (actor != null) {
            Assert.check(actor instanceof VerticalGroup, "Child must be a VerticalGroup", new Object[0]);
            this.mGroup = (VerticalGroup)actor;
        }
    }

    @Override
    protected void sizeChanged() {
        if (this.mGroup != null) {
            this.mGroup.setWidth(this.getWidth());
        }
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        UiInputMapper inputMapper = UiInputMapper.getInstance();
        if (inputMapper.isKeyJustPressed(VirtualKey.DOWN)) {
            this.scroll(1);
        } else if (inputMapper.isKeyJustPressed(VirtualKey.UP)) {
            this.scroll(-1);
        }
    }

    private void scroll(int dy) {
        float scrollAmount = this.getHeight() / 2.0f;
        float y = MathUtils.clamp(this.getScrollY() + scrollAmount * (float)dy, 0.0f, this.getMaxY());
        this.setScrollY(y);
    }

    private void setupAutoScroll() {
        this.addAction(new Action(){

            @Override
            public boolean act(float delta) {
                float maxY = CreditsScrollPane.this.getMaxY();
                float y = Math.min(CreditsScrollPane.this.getScrollY() + 45.0f * delta, maxY);
                CreditsScrollPane.this.setScrollY(y);
                return false;
            }
        });
    }
}

