/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.Pools;

public class Scene2dUtils {
    private static final float FAKE_TOUCH_DELAY = 0.1f;

    public static void simulateClick(Actor target) {
        Clicker clicker = Pools.obtain(Clicker.class);
        clicker.click(target);
    }

    public static void fireTouchEvent(Actor target, float stageX, float stageY, InputEvent.Type type) {
        InputEvent event = Pools.obtain(InputEvent.class);
        event.setType(type);
        event.setStage(target.getStage());
        event.setStageX(stageX);
        event.setStageY(stageY);
        event.setPointer(0);
        event.setButton(0);
        target.fire(event);
        Pools.free(event);
    }

    public static void fireChangeEvent(Actor target) {
        ChangeListener.ChangeEvent event = Pools.obtain(ChangeListener.ChangeEvent.class);
        event.setStage(target.getStage());
        target.fire(event);
        Pools.free(event);
    }

    private static class Clicker
    implements Pool.Poolable,
    Runnable {
        private Actor mTarget;
        private final Vector2 mClickCoords = new Vector2();

        private Clicker() {
        }

        @Override
        public void reset() {
            this.mTarget = null;
        }

        public void click(Actor target) {
            this.mTarget = target;
            this.mClickCoords.set(target.getWidth() / 2.0f, target.getHeight() / 2.0f);
            target.localToStageCoordinates(this.mClickCoords);
            Scene2dUtils.fireTouchEvent(this.mTarget, this.mClickCoords.x, this.mClickCoords.y, InputEvent.Type.touchDown);
            target.addAction(Actions.delay(0.1f, Actions.run(this)));
        }

        @Override
        public void run() {
            Scene2dUtils.fireTouchEvent(this.mTarget, this.mClickCoords.x, this.mClickCoords.y, InputEvent.Type.touchUp);
            Pools.free(this);
        }
    }
}

