/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui.menu;

import com.agateau.ui.menu.Menu;
import com.agateau.ui.menu.MenuItem;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;

public class MenuScrollPane
extends ScrollPane {
    private Menu mMenu;
    private final Vector2 mTmp = new Vector2();
    private final ChangeListener mListener = new ChangeListener(){

        @Override
        public void changed(ChangeListener.ChangeEvent event, Actor actor) {
            MenuScrollPane.this.layout();
            MenuScrollPane.this.ensureItemVisible();
        }
    };

    public MenuScrollPane(Menu menu) {
        super((Actor)null);
        this.setCancelTouchFocus(false);
        this.setMenu(menu);
    }

    public Menu getMenu() {
        return this.mMenu;
    }

    public void setMenu(Menu menu) {
        this.setActor(menu);
        this.mMenu = menu;
        this.mMenu.addListener(this.mListener);
    }

    @Override
    public float getPrefWidth() {
        return this.mMenu.getWidth();
    }

    private void ensureItemVisible() {
        Menu.MenuStyle style = this.mMenu.getMenuStyle();
        MenuItem item = this.mMenu.getCurrentItem();
        Rectangle rect = item.getFocusRectangle();
        this.mTmp.set(rect.x, rect.y);
        item.getActor().localToAscendantCoordinates(this.mMenu, this.mTmp);
        this.scrollTo(this.mTmp.x - (float)style.focusPadding, this.mTmp.y - (float)style.focusPadding, rect.width + (float)(2 * style.focusPadding), rect.height + (float)(2 * style.focusPadding));
    }
}

