/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.map;

import com.agateau.pixelwheels.map.Track;
import com.agateau.translations.Translator;
import com.badlogic.gdx.utils.Array;

public class Championship {
    private final String mId;
    private final String mName;
    private final Array<Track> mTracks = new Array();

    public Championship(String id, String name) {
        this.mId = id;
        this.mName = name;
    }

    public Track addTrack(String trackId, String trackName) {
        Track track = new Track(this, trackId, trackName);
        this.mTracks.add(track);
        return track;
    }

    public String getId() {
        return this.mId;
    }

    public String getName() {
        return Translator.trc(this.mName, "championship");
    }

    public Array<Track> getTracks() {
        return this.mTracks;
    }

    public String toString() {
        return "championship(" + this.mId + ")";
    }
}

