/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.obstacles;

import com.agateau.pixelwheels.GamePlay;
import com.agateau.pixelwheels.TextureRegionProvider;
import com.agateau.pixelwheels.ZLevel;
import com.agateau.pixelwheels.gameobject.GameObjectAdapter;
import com.agateau.pixelwheels.obstacles.ObstacleDef;
import com.agateau.pixelwheels.utils.BodyRegionDrawer;
import com.agateau.pixelwheels.utils.Box2DUtils;
import com.agateau.pixelwheels.utils.DrawUtils;
import com.agateau.utils.AgcMathUtils;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.utils.Disposable;

public class Obstacle
extends GameObjectAdapter
implements Disposable {
    private static final float LINEAR_DRAG = 90.0f;
    private static final float ANGULAR_DRAG = 2.0f;
    private final World mWorld;
    private final Body mBody;
    private final TextureRegion mRegion;
    private final float mRegionRadius;
    private final BodyRegionDrawer mBodyRegionDrawer = new BodyRegionDrawer();

    Obstacle(World box2DWorld, TextureRegionProvider provider, ObstacleDef obstacleDef, BodyDef bodyDef) {
        this.mWorld = box2DWorld;
        this.mBody = box2DWorld.createBody(bodyDef);
        this.mBody.createFixture(Box2DUtils.createBox2DShape(obstacleDef.shape, 0.05f), obstacleDef.density);
        this.mRegion = obstacleDef.getImage(provider);
        this.mRegionRadius = 0.05f * DrawUtils.getTextureRegionRadius(this.mRegion);
        Box2DUtils.setCollisionInfo(this.mBody, 15, 15);
        if (!obstacleDef.dynamic) {
            Obstacle.setStaticObstacleRestitution(this.mBody);
        }
    }

    @Override
    public void act(float delta) {
        Box2DUtils.applyDrag(this.mBody, 90.0f);
        Box2DUtils.applyCircularDrag(this.mBody, 2.0f);
    }

    @Override
    public void draw(Batch batch, ZLevel zLevel, Rectangle viewBounds) {
        if (zLevel != ZLevel.ON_GROUND && zLevel != ZLevel.GROUND) {
            return;
        }
        if (!AgcMathUtils.rectangleContains(viewBounds, this.getPosition(), this.mRegionRadius)) {
            return;
        }
        if (zLevel == ZLevel.ON_GROUND) {
            this.mBodyRegionDrawer.setBatch(batch);
            this.mBodyRegionDrawer.draw(this.mBody, this.mRegion);
        } else {
            this.mBodyRegionDrawer.setBatch(batch);
            this.mBodyRegionDrawer.drawShadow(this.mBody, this.mRegion);
        }
    }

    @Override
    public float getX() {
        return this.mBody.getPosition().x;
    }

    @Override
    public float getY() {
        return this.mBody.getPosition().y;
    }

    @Override
    public void dispose() {
        this.mWorld.destroyBody(this.mBody);
    }

    public static void setStaticObstacleRestitution(Body body) {
        float restitution = (float)GamePlay.instance.borderRestitution / 10.0f;
        for (Fixture fixture : body.getFixtureList()) {
            fixture.setRestitution(restitution);
        }
    }
}

