/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.pixelwheels.stats;

import com.agateau.pixelwheels.stats.GameStats;
import com.agateau.pixelwheels.stats.TrackResult;
import java.util.ArrayList;

public class TrackStats {
    public static final int RECORD_COUNT = 3;
    public static final String DEFAULT_RECORD_VEHICLE = "CPU";
    private final GameStats mGameStats;
    final ArrayList<TrackResult> mLapRecords;
    final ArrayList<TrackResult> mTotalRecords;

    TrackStats(GameStats gameStats) {
        this.mGameStats = gameStats;
        this.mLapRecords = new ArrayList();
        this.mTotalRecords = new ArrayList();
    }

    public ArrayList<TrackResult> get(ResultType resultType) {
        return resultType == ResultType.LAP ? this.mLapRecords : this.mTotalRecords;
    }

    public int addResult(ResultType resultType, String vehicleName, float time) {
        TrackResult result = new TrackResult(vehicleName, time);
        int rank = TrackStats.addResult(this.get(resultType), result);
        if (rank != -1) {
            this.mGameStats.save();
        }
        return rank;
    }

    private static int addResult(ArrayList<TrackResult> results, TrackResult result) {
        for (int idx = 0; idx < results.size(); ++idx) {
            if (!(result.value < results.get((int)idx).value)) continue;
            results.add(idx, result);
            if (results.size() > 3) {
                results.remove(3);
            }
            return idx;
        }
        if (results.size() < 3) {
            results.add(result);
            return results.size() - 1;
        }
        return -1;
    }

    public static enum ResultType {
        LAP,
        TOTAL;

    }
}

