/*
 * Decompiled with CFR 0.152.
 */
package com.agateau.ui.menu;

import com.agateau.ui.menu.Menu;
import com.agateau.ui.menu.RangeMenuItem;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;

public class SliderMenuItem
extends RangeMenuItem {
    private static final float NO_DIVISOR = -1.0f;
    private SliderMainActor mMainActor;
    private int mMin = 0;
    private int mMax = 100;
    private int mStepSize = 1;
    private float mDivisor = -1.0f;
    private int mValue = 0;

    public SliderMenuItem(Menu menu) {
        super(menu);
    }

    public void setRange(int min, int max) {
        this.setRange(min, max, 1);
    }

    public void setRange(int min, int max, int stepSize) {
        this.mMin = min;
        this.mMax = max;
        this.mStepSize = stepSize;
        this.mDivisor = -1.0f;
        this.setIntValue(this.getIntValue());
    }

    public void setRange(float min, float max, float stepSize) {
        this.mStepSize = 1;
        this.mDivisor = 1.0f / stepSize;
        this.mMin = (int)(min * this.mDivisor);
        this.mMax = (int)(max * this.mDivisor);
        this.setIntValue(this.getIntValue());
    }

    public boolean isAtMinimumValue() {
        return this.mValue == this.mMin;
    }

    public void setToMinimumValue() {
        this.mValue = this.mMin;
    }

    public int getIntValue() {
        return this.mValue;
    }

    public void setIntValue(int value) {
        this.mValue = MathUtils.clamp(value, this.mMin, this.mMax);
        int reminder = (this.mValue - this.mMin) % this.mStepSize;
        if (reminder > 0) {
            this.mValue -= reminder;
        }
        this.updateMainActor();
    }

    public void setFloatValue(float value) {
        this.setIntValue((int)(value * this.mDivisor));
    }

    public float getFloatValue() {
        return (float)this.mValue / this.mDivisor;
    }

    @Override
    protected Actor createMainActor(Menu menu) {
        this.mMainActor = new SliderMainActor(menu.getSkin(), this);
        return this.mMainActor;
    }

    @Override
    public void updateMainActor() {
        if (this.mMainActor == null) {
            return;
        }
        this.mMainActor.setPercent((float)(this.mValue - this.mMin) / (float)(this.mMax - this.mMin));
        this.mMainActor.setText(this.formatValue(this.getIntValue()));
    }

    @Override
    protected void decrease() {
        this.setIntValue(this.mValue - this.mStepSize);
    }

    @Override
    protected void increase() {
        this.setIntValue(this.mValue + this.mStepSize);
    }

    protected String formatValue(int value) {
        if (this.mDivisor == -1.0f) {
            return String.valueOf(value);
        }
        return String.valueOf((float)value / this.mDivisor);
    }

    protected float getDivisor() {
        return this.mDivisor;
    }

    private void onSliderChanged(float percent) {
        this.setIntValue(this.mMin + (int)(percent * (float)(this.mMax - this.mMin)));
        this.fireChangeEvent();
    }

    private static class SliderMainActor
    extends Actor {
        private final Skin mSkin;
        private final SliderMenuItemStyle mStyle;
        private final BitmapFont mFont;
        private final SliderMenuItem mMenuItem;
        private String mText;
        private float mPercent = 0.0f;

        SliderMainActor(Skin skin, SliderMenuItem menuItem) {
            this.mSkin = skin;
            this.mStyle = this.mSkin.get("default", SliderMenuItemStyle.class);
            this.mFont = this.mSkin.get("default-font", BitmapFont.class);
            this.mMenuItem = menuItem;
            this.setTouchable(Touchable.enabled);
            this.addCaptureListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                    mMenuItem.onSliderChanged(this.computePercent(x));
                    return true;
                }

                @Override
                public void touchDragged(InputEvent event, float x, float y, int pointer) {
                    mMenuItem.onSliderChanged(this.computePercent(x));
                }

                private float computePercent(float x) {
                    float handleWidth = ((SliderMainActor)this).mStyle.handle.getMinWidth();
                    float fullWidth = this.getWidth() - ((SliderMainActor)this).mStyle.framePadding * 2.0f - handleWidth;
                    return (x - ((SliderMainActor)this).mStyle.framePadding - handleWidth / 2.0f) / fullWidth;
                }
            });
        }

        @Override
        public void draw(Batch batch, float parentAlpha) {
            float handleWidth = this.mStyle.handle.getMinWidth();
            float fullWidth = this.getWidth() - this.mStyle.framePadding * 2.0f - handleWidth;
            float handleX = this.getX() + this.mStyle.framePadding + fullWidth * this.mPercent;
            this.mStyle.handle.draw(batch, handleX, this.getY(), handleWidth, this.getHeight());
            float y = this.getY() + (this.mFont.getCapHeight() + this.getHeight()) / 2.0f;
            this.mFont.draw(batch, this.mText, this.getX(), y, this.getWidth(), 1, false);
        }

        public void setPercent(float percent) {
            this.mPercent = percent;
        }

        public void setText(String text) {
            this.mText = text;
        }
    }

    public static class SliderMenuItemStyle
    extends RangeMenuItem.RangeMenuItemStyle {
        Drawable handle;
    }
}

